/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise;

import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.MiscDisguise;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class DisguiseAPI {
    private static int selfDisguiseId;
    private static int entityAttachmentId;

    public static int getEntityAttachmentId() {
        if (entityAttachmentId == 0) {
            entityAttachmentId = ReflectionManager.getNewEntityId();
        }
        return entityAttachmentId;
    }

    public static void addCustomDisguise(String string, String string2) {
        string = string.replace(".", "");
        try {
            YamlConfiguration yamlConfiguration;
            DisguiseConfig.removeCustomDisguise(string);
            DisguiseConfig.addCustomDisguise(string, string2);
            File file = new File(LibsDisguises.getInstance().getDataFolder(), "configs/disguises.yml");
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            if (!(yamlConfiguration = YamlConfiguration.loadConfiguration((File)file)).isConfigurationSection("Disguises")) {
                yamlConfiguration.createSection("Disguises");
            }
            ConfigurationSection configurationSection = yamlConfiguration.getConfigurationSection("Disguises");
            configurationSection.set(string, (Object)string2.replace("\n", "\\n").replace("\r", "\\r"));
            yamlConfiguration.save(file);
            DisguiseUtilities.getLogger().info("Added new Custom Disguise " + string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void addGameProfile(String string, WrappedGameProfile wrappedGameProfile) {
        DisguiseUtilities.addGameProfile(string, wrappedGameProfile);
    }

    public static String getRawCustomDisguise(String string) {
        Map.Entry<DisguisePerm, String> entry = DisguiseConfig.getRawCustomDisguise(string);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public static Disguise getCustomDisguise(String string) {
        Map.Entry<DisguisePerm, Disguise> entry = DisguiseConfig.getCustomDisguise(string);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public static Disguise constructDisguise(Entity entity) {
        return DisguiseAPI.constructDisguise(entity, true, false);
    }

    public static Disguise constructDisguise(Entity entity, boolean bl, boolean bl2) {
        WrappedDataWatcher wrappedDataWatcher;
        DisguiseType disguiseType = DisguiseType.getType(entity);
        TargetedDisguise targetedDisguise = disguiseType.isMisc() ? new MiscDisguise(disguiseType) : (disguiseType.isMob() ? new MobDisguise(disguiseType) : new PlayerDisguise(entity.getName()));
        FlagWatcher flagWatcher = targetedDisguise.getWatcher();
        if (bl && entity instanceof LivingEntity) {
            WrappedWatchableObject wrappedWatchableObject;
            wrappedDataWatcher = ((LivingEntity)entity).getEquipment();
            flagWatcher.setArmor(wrappedDataWatcher.getArmorContents());
            ItemStack itemStack = wrappedDataWatcher.getItemInMainHand();
            if (itemStack != null && itemStack.getType() != Material.AIR) {
                flagWatcher.setItemInMainHand(itemStack);
            }
            if ((wrappedWatchableObject = wrappedDataWatcher.getItemInMainHand()) != null && wrappedWatchableObject.getType() != Material.AIR) {
                flagWatcher.setItemInOffHand((ItemStack)wrappedWatchableObject);
            }
        }
        wrappedDataWatcher = WrappedDataWatcher.getEntityWatcher((Entity)entity);
        for (WrappedWatchableObject wrappedWatchableObject : wrappedDataWatcher.getWatchableObjects()) {
            LivingWatcher livingWatcher;
            MetaIndex metaIndex = MetaIndex.getMetaIndex(flagWatcher.getClass(), wrappedWatchableObject.getIndex());
            if (metaIndex == null || metaIndex.getDefault() == wrappedWatchableObject.getValue() || metaIndex.getDefault() == wrappedWatchableObject.getRawValue()) continue;
            flagWatcher.setUnsafeData(metaIndex, wrappedWatchableObject.getRawValue());
            if (metaIndex == MetaIndex.ENTITY_META) {
                flagWatcher.setSprinting(flagWatcher.isSprinting() && bl2);
                flagWatcher.setFlyingWithElytra(flagWatcher.isFlyingWithElytra() && bl2);
                flagWatcher.setSneaking(flagWatcher.isSneaking() && bl2);
                flagWatcher.setSwimming(flagWatcher.isSwimming() && bl2);
                if (!NmsVersion.v1_13.isSupported()) {
                    flagWatcher.setMainHandRaised(flagWatcher.isMainHandRaised() && bl2);
                }
                if (!bl2) {
                    Arrays.fill(flagWatcher.getModifiedEntityAnimations(), false);
                }
                flagWatcher.setGlowing(flagWatcher.isGlowing());
                flagWatcher.setInvisible(flagWatcher.isInvisible());
                continue;
            }
            if (metaIndex != MetaIndex.LIVING_META || !NmsVersion.v1_13.isSupported()) continue;
            livingWatcher.setMainHandRaised((livingWatcher = (LivingWatcher)flagWatcher).isMainHandRaised() && bl2);
            livingWatcher.setOffhandRaised(livingWatcher.isOffhandRaised() && bl2);
            livingWatcher.setSpinning(livingWatcher.isSpinning() && bl2);
            if (bl2) continue;
            Arrays.fill(livingWatcher.getModifiedLivingAnimations(), false);
        }
        return targetedDisguise;
    }

    public static void disguiseEntity(Entity entity, Disguise disguise) {
        DisguiseAPI.disguiseEntity(null, entity, disguise);
    }

    public static void disguiseEntity(CommandSender commandSender, Entity entity, Disguise disguise) {
        if (entity == null || disguise == null) {
            return;
        }
        if (disguise.getEntity() != entity) {
            if (disguise.getEntity() != null) {
                disguise = disguise.clone();
            }
            disguise.setEntity(entity);
        }
        if (DisguiseAPI.hasSelfDisguisePreference(entity) && disguise.isSelfDisguiseVisible() == DisguiseConfig.isViewSelfDisguisesDefault()) {
            disguise.setViewSelfDisguise(!disguise.isSelfDisguiseVisible());
        }
        if (DisguiseAPI.hasActionBarPreference(entity) && !DisguiseAPI.isNotifyBarShown(entity)) {
            disguise.setNotifyBar(DisguiseConfig.NotifyBar.NONE);
        }
        disguise.startDisguise(commandSender);
    }

    public static void disguiseIgnorePlayers(Entity entity, Disguise disguise, Collection collection) {
        if (disguise.getEntity() != null) {
            disguise = disguise.clone();
        }
        ((TargetedDisguise)disguise).setDisguiseTarget(TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS);
        for (Object e : collection) {
            if (e instanceof String) {
                ((TargetedDisguise)disguise).addPlayer((String)e);
                continue;
            }
            if (!(e instanceof Player)) continue;
            ((TargetedDisguise)disguise).addPlayer(((Player)e).getName());
        }
        DisguiseAPI.disguiseEntity(entity, disguise);
    }

    @Deprecated
    public static void disguiseIgnorePlayers(Entity entity, Disguise disguise, List<String> list) {
        DisguiseAPI.disguiseIgnorePlayers(entity, disguise, list);
    }

    public static void disguiseIgnorePlayers(Entity entity, Disguise disguise, Player ... playerArray) {
        DisguiseAPI.disguiseIgnorePlayers(entity, disguise, Arrays.asList(playerArray));
    }

    public static void disguiseIgnorePlayers(Entity entity, Disguise disguise, String ... stringArray) {
        DisguiseAPI.disguiseIgnorePlayers(entity, disguise, Arrays.asList(stringArray));
    }

    public static int disguiseNextEntity(Disguise disguise) {
        if (disguise == null) {
            return -1;
        }
        if (disguise.getEntity() != null || DisguiseUtilities.getDisguises().containsValue(disguise)) {
            disguise = disguise.clone();
        }
        int n = ReflectionManager.getNewEntityId(false);
        DisguiseUtilities.addFutureDisguise(n, (TargetedDisguise)disguise);
        return n;
    }

    public static void disguiseToAll(Entity entity, Disguise disguise) {
        if (disguise.getEntity() != null) {
            disguise = disguise.clone();
        }
        ((TargetedDisguise)disguise).setDisguiseTarget(TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS);
        for (String string : ((TargetedDisguise)disguise).getObservers()) {
            ((TargetedDisguise)disguise).removePlayer(string);
        }
        DisguiseAPI.disguiseEntity(entity, disguise);
    }

    public static void disguiseToPlayers(Entity entity, Disguise disguise, Collection collection) {
        if (disguise.getEntity() != null) {
            disguise = disguise.clone();
        }
        ((TargetedDisguise)disguise).setDisguiseTarget(TargetedDisguise.TargetType.HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS);
        for (Object e : collection) {
            if (e instanceof String) {
                ((TargetedDisguise)disguise).addPlayer((String)e);
                continue;
            }
            if (!(e instanceof Player)) continue;
            ((TargetedDisguise)disguise).addPlayer(((Player)e).getName());
        }
        DisguiseAPI.disguiseEntity(entity, disguise);
    }

    @Deprecated
    public static void disguiseToPlayers(Entity entity, Disguise disguise, List<String> list) {
        DisguiseAPI.disguiseToPlayers(entity, disguise, list);
    }

    public static void disguiseToPlayers(Entity entity, Disguise disguise, Player ... playerArray) {
        DisguiseAPI.disguiseToPlayers(entity, disguise, Arrays.asList(playerArray));
    }

    public static void disguiseToPlayers(Entity entity, Disguise disguise, String ... stringArray) {
        DisguiseAPI.disguiseToPlayers(entity, disguise, Arrays.asList(stringArray));
    }

    private static int firstCapital(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isUpperCase(string.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static Disguise getDisguise(Entity entity) {
        if (entity == null) {
            return null;
        }
        return DisguiseUtilities.getMainDisguise(entity.getEntityId());
    }

    public static String parseToString(Disguise disguise, boolean bl) {
        return DisguiseParser.parseToString(disguise, bl);
    }

    public static String parseToString(Disguise disguise) {
        return DisguiseAPI.parseToString(disguise, true);
    }

    public static Disguise getDisguise(Player player, Entity entity) {
        if (entity == null || player == null) {
            return null;
        }
        return DisguiseUtilities.getDisguise(player, entity);
    }

    public static Disguise[] getDisguises(Entity entity) {
        if (entity == null) {
            return null;
        }
        return DisguiseUtilities.getDisguises(entity.getEntityId());
    }

    public static int getSelfDisguiseId() {
        if (selfDisguiseId == 0) {
            selfDisguiseId = ReflectionManager.getNewEntityId();
        }
        return selfDisguiseId;
    }

    public static boolean isDisguised(Entity entity) {
        return DisguiseAPI.getDisguise(entity) != null;
    }

    public static boolean isDisguised(Player player, Entity entity) {
        return DisguiseAPI.getDisguise(player, entity) != null;
    }

    public static boolean isDisguiseInUse(Disguise disguise) {
        return disguise.isDisguiseInUse();
    }

    public static boolean isSelfDisguised(Player player) {
        return DisguiseUtilities.getSelfDisguised().contains(player.getUniqueId());
    }

    public static boolean isViewSelfToggled(Entity entity) {
        return DisguiseAPI.hasSelfDisguisePreference(entity) != DisguiseConfig.isViewSelfDisguisesDefault();
    }

    @Deprecated
    public static boolean isActionBarShown(Entity entity) {
        return DisguiseAPI.isNotifyBarShown(entity);
    }

    public static boolean isNotifyBarShown(Entity entity) {
        return DisguiseConfig.getNotifyBar() == DisguiseConfig.NotifyBar.NONE == DisguiseAPI.hasActionBarPreference(entity);
    }

    public static boolean hasSelfDisguisePreference(Entity entity) {
        return DisguiseUtilities.getViewSelf().contains(entity.getUniqueId());
    }

    public static boolean hasActionBarPreference(Entity entity) {
        return DisguiseUtilities.getViewBar().contains(entity.getUniqueId());
    }

    public static void undisguiseToAll(Entity entity) {
        DisguiseAPI.undisguiseToAll(null, entity);
    }

    public static void undisguiseToAll(CommandSender commandSender, Entity entity) {
        Disguise[] disguiseArray;
        for (Disguise disguise : disguiseArray = DisguiseAPI.getDisguises(entity)) {
            disguise.removeDisguise(commandSender);
        }
    }

    public static void setViewDisguiseToggled(Entity entity, boolean bl) {
        if (DisguiseAPI.isDisguised(entity)) {
            Disguise[] disguiseArray;
            for (Disguise disguise : disguiseArray = DisguiseAPI.getDisguises(entity)) {
                disguise.setViewSelfDisguise(bl);
            }
        }
        if (!bl == DisguiseConfig.isViewSelfDisguisesDefault()) {
            if (!DisguiseAPI.hasSelfDisguisePreference(entity)) {
                DisguiseUtilities.getViewSelf().add(entity.getUniqueId());
                DisguiseUtilities.addSaveAttempt();
            }
        } else {
            DisguiseUtilities.getViewSelf().remove(entity.getUniqueId());
            DisguiseUtilities.addSaveAttempt();
        }
    }

    public static void setActionBarShown(Player player, boolean bl) {
        if (DisguiseAPI.isDisguised((Entity)player)) {
            Disguise[] disguiseArray;
            for (Disguise disguise : disguiseArray = DisguiseAPI.getDisguises((Entity)player)) {
                disguise.setNotifyBar(bl ? DisguiseConfig.getNotifyBar() : DisguiseConfig.NotifyBar.NONE);
            }
        }
        if (!bl) {
            if (!DisguiseAPI.hasActionBarPreference((Entity)player)) {
                DisguiseUtilities.getViewBar().add(player.getUniqueId());
                DisguiseUtilities.addSaveAttempt();
            }
        } else {
            DisguiseUtilities.getViewBar().remove(player.getUniqueId());
            DisguiseUtilities.addSaveAttempt();
        }
    }

    private DisguiseAPI() {
    }
}

