/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.serializer.gson;

import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import ld-shaded.net.kyori.adventure.util.Index;

final class IndexedSerializer<E>
extends TypeAdapter<E> {
    private final String name;
    private final Index<String, E> map;

    public static <E> TypeAdapter<E> of(String string, Index<String, E> index) {
        return new IndexedSerializer<E>(string, index).nullSafe();
    }

    private IndexedSerializer(String string, Index<String, E> index) {
        this.name = string;
        this.map = index;
    }

    public void write(JsonWriter jsonWriter, E e) {
        jsonWriter.value(this.map.key(e));
    }

    public E read(JsonReader jsonReader) {
        String string = jsonReader.nextString();
        E e = this.map.value(string);
        if (e != null) {
            return e;
        }
        throw new JsonParseException("invalid " + this.name + ":  " + string);
    }
}

