/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.minimessage.Context;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.ParsingException;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.TagPart;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Inserting;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Transformation;
import ld-shaded.net.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;

public final class TranslatableTransformation
extends Transformation
implements Inserting {
    private final String key;
    private final List<Component> inners;

    public static TranslatableTransformation create(Context context, String string, List<TagPart> list) {
        List<Component> list2;
        if (list.isEmpty()) {
            throw new ParsingException("Doesn't know how to turn " + list + " into a translatable component", list);
        }
        if (list.size() > 1) {
            list2 = new ArrayList();
            for (TagPart tagPart : list.subList(1, list.size())) {
                list2.add(context.parse(tagPart.value()));
            }
        } else {
            list2 = Collections.emptyList();
        }
        return new TranslatableTransformation(list.get(0).value(), list2);
    }

    private TranslatableTransformation(String string, List<Component> list) {
        this.key = string;
        this.inners = list;
    }

    @Override
    public Component apply() {
        if (this.inners.isEmpty()) {
            return Component.translatable(this.key);
        }
        return Component.translatable(this.key, this.inners);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("key", this.key), ExaminableProperty.of("inners", this.inners));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TranslatableTransformation translatableTransformation = (TranslatableTransformation)object;
        return Objects.equals(this.key, translatableTransformation.key) && Objects.equals(this.inners, translatableTransformation.inners);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, this.inners);
    }
}

