/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.stream.Stream;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.TextComponent;
import ld-shaded.net.kyori.adventure.text.flattener.ComponentFlattener;
import ld-shaded.net.kyori.adventure.text.format.TextColor;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.ParsingException;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.ElementNode;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.TagNode;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.TagPart;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.ValueNode;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Modifying;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Transformation;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild.TemplateTransformation;
import ld-shaded.net.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;

public final class RainbowTransformation
extends Transformation
implements Modifying {
    private int size;
    private int disableApplyingColorDepth = -1;
    private int colorIndex = 0;
    private float center = 128.0f;
    private float width = 127.0f;
    private double frequency = 1.0;
    private final boolean reversed;
    private final int phase;

    public static RainbowTransformation create(String string, List<TagPart> list) {
        boolean bl = false;
        int n = 0;
        if (list.size() == 1) {
            String string2 = list.get(0).value();
            if (list.get(0).value().startsWith("!")) {
                bl = true;
                string2 = string2.replaceFirst("!", "");
            }
            if (string2.length() > 0) {
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParsingException("Expected phase, got " + list.get(0), list);
                }
            }
        }
        return new RainbowTransformation(bl, n);
    }

    private RainbowTransformation(boolean bl, int n) {
        this.reversed = bl;
        this.phase = n;
    }

    @Override
    public void visit(ElementNode elementNode) {
        TagNode tagNode;
        if (elementNode instanceof ValueNode) {
            String string2 = ((ValueNode)elementNode).value();
            this.size += string2.codePointCount(0, string2.length());
        } else if (elementNode instanceof TagNode && (tagNode = (TagNode)elementNode).transformation() instanceof TemplateTransformation) {
            ComponentFlattener.textOnly().flatten(tagNode.transformation().apply(), string -> this.size += string.codePointCount(0, string.length()));
        }
    }

    @Override
    public Component apply() {
        this.center = 128.0f;
        this.width = 127.0f;
        this.frequency = Math.PI * 2 / (double)this.size;
        return Component.empty();
    }

    @Override
    public Component apply(Component component, int n) {
        if (this.disableApplyingColorDepth != -1 && n > this.disableApplyingColorDepth || component.style().color() != null) {
            if (this.disableApplyingColorDepth == -1) {
                this.disableApplyingColorDepth = n;
            }
            if (component instanceof TextComponent) {
                String string = ((TextComponent)component).content();
                int n2 = string.codePointCount(0, string.length());
                for (int i = 0; i < n2; ++i) {
                    this.color(this.phase);
                }
            }
            return component.children(Collections.emptyList());
        }
        this.disableApplyingColorDepth = -1;
        if (component instanceof TextComponent && ((TextComponent)component).content().length() > 0) {
            TextComponent textComponent = (TextComponent)component;
            String string = textComponent.content();
            TextComponent.Builder builder = Component.text();
            if (this.colorIndex == 0 && this.reversed) {
                this.colorIndex = this.size - 1;
            }
            int[] nArray = new int[1];
            PrimitiveIterator.OfInt ofInt = string.codePoints().iterator();
            while (ofInt.hasNext()) {
                nArray[0] = ofInt.nextInt();
                TextComponent textComponent2 = Component.text(new String(nArray, 0, 1), this.color(this.phase));
                builder.append((Component)textComponent2);
            }
            return builder.build();
        }
        return Component.empty().mergeStyle(component);
    }

    private TextColor color(float f) {
        int n;
        if (this.reversed) {
            int n2 = this.colorIndex;
            n = n2;
            this.colorIndex = n2 - 1;
        } else {
            int n3 = this.colorIndex;
            n = n3;
            this.colorIndex = n3 + 1;
        }
        int n4 = n;
        int n5 = (int)(Math.sin(this.frequency * (double)n4 + 2.0 + (double)f) * (double)this.width + (double)this.center);
        int n6 = (int)(Math.sin(this.frequency * (double)n4 + 0.0 + (double)f) * (double)this.width + (double)this.center);
        int n7 = (int)(Math.sin(this.frequency * (double)n4 + 4.0 + (double)f) * (double)this.width + (double)this.center);
        return TextColor.color(n5, n6, n7);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("phase", this.phase));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RainbowTransformation rainbowTransformation = (RainbowTransformation)object;
        return this.colorIndex == rainbowTransformation.colorIndex && Float.compare(rainbowTransformation.center, this.center) == 0 && Float.compare(rainbowTransformation.width, this.width) == 0 && Double.compare(rainbowTransformation.frequency, this.frequency) == 0 && this.phase == rainbowTransformation.phase;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.colorIndex, Float.valueOf(this.center), Float.valueOf(this.width), this.frequency, this.phase);
    }
}

