/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.ParsingException;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.TagPart;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Inserting;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Transformation;
import ld-shaded.net.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;

public final class KeybindTransformation
extends Transformation
implements Inserting {
    private final String keybind;

    public static KeybindTransformation create(String string, List<TagPart> list) {
        if (list.size() != 1) {
            throw new ParsingException("Doesn't know how to turn token with name '" + string + "' and arguments " + list + " into a keybind component", list);
        }
        return new KeybindTransformation(list.get(0).value());
    }

    private KeybindTransformation(String string) {
        this.keybind = string;
    }

    @Override
    public Component apply() {
        return Component.keybind(this.keybind);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("keybind", this.keybind));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        KeybindTransformation keybindTransformation = (KeybindTransformation)object;
        return Objects.equals(this.keybind, keybindTransformation.keybind);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.keybind);
    }
}

