/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.ParsingException;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.TagPart;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Transformation;
import ld-shaded.net.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;

public final class InsertionTransformation
extends Transformation {
    private final String insertion;

    public static InsertionTransformation create(String string, List<TagPart> list) {
        if (list.size() != 1) {
            throw new ParsingException("Doesn't know how to turn token with name '" + string + "' and arguments " + list + " into a insertion component", list);
        }
        return new InsertionTransformation(list.get(0).value());
    }

    private InsertionTransformation(String string) {
        this.insertion = string;
    }

    @Override
    public Component apply() {
        return Component.empty().insertion(this.insertion);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("insertion", this.insertion));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        InsertionTransformation insertionTransformation = (InsertionTransformation)object;
        return Objects.equals(this.insertion, insertionTransformation.insertion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.insertion);
    }
}

