/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import ld-shaded.net.kyori.adventure.key.InvalidKeyException;
import ld-shaded.net.kyori.adventure.key.Key;
import ld-shaded.net.kyori.adventure.nbt.api.BinaryTagHolder;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.event.HoverEvent;
import ld-shaded.net.kyori.adventure.text.minimessage.Context;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.ParsingException;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.Token;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.TagPart;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Transformation;
import ld-shaded.net.kyori.examination.Examinable;
import ld-shaded.net.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;

public final class HoverTransformation
extends Transformation {
    private final HoverEvent.Action<Object> action;
    private final Object value;

    public static HoverTransformation create(Context context, String string, List<TagPart> list) {
        Examinable examinable;
        if (list.size() < 2) {
            throw new ParsingException("Doesn't know how to turn " + list + " into a hover event", list);
        }
        List<TagPart> list2 = list.subList(1, list.size());
        HoverEvent.Action<Object> action = HoverEvent.Action.NAMES.value(list.get(0).value());
        if (action == HoverEvent.Action.SHOW_TEXT) {
            examinable = context.parse(list2.get(0).value());
        } else if (action == HoverEvent.Action.SHOW_ITEM) {
            examinable = HoverTransformation.parseShowItem(list2);
        } else if (action == HoverEvent.Action.SHOW_ENTITY) {
            examinable = HoverTransformation.parseShowEntity(list2, context);
        } else {
            throw new ParsingException("Don't know how to turn '" + list + "' into a hover event", list);
        }
        return new HoverTransformation(action, examinable);
    }

    private static @NotNull HoverEvent.ShowItem parseShowItem(@NotNull List<TagPart> list) {
        try {
            if (list.isEmpty()) {
                throw new ParsingException("Show item hover needs at least item id!", new Token[0]);
            }
            Key key = Key.key(list.get(0).value());
            int n = list.size() >= 2 ? Integer.parseInt(list.get(1).value()) : 1;
            if (list.size() == 3) {
                return HoverEvent.ShowItem.of(key, n, BinaryTagHolder.of(list.get(2).value()));
            }
            return HoverEvent.ShowItem.of(key, n);
        }
        catch (NumberFormatException | InvalidKeyException runtimeException) {
            throw new ParsingException("Exception parsing show_item hover", (Throwable)runtimeException, list);
        }
    }

    private static @NotNull HoverEvent.ShowEntity parseShowEntity(@NotNull List<TagPart> list, Context context) {
        try {
            if (list.size() < 2) {
                throw new ParsingException("Show entity hover needs at least type and uuid!", new Token[0]);
            }
            Key key = Key.key(list.get(0).value());
            UUID uUID = UUID.fromString(list.get(1).value());
            if (list.size() == 3) {
                Component component = context.parse(list.get(2).value());
                return HoverEvent.ShowEntity.of(key, uUID, component);
            }
            return HoverEvent.ShowEntity.of(key, uUID);
        }
        catch (IllegalArgumentException | InvalidKeyException runtimeException) {
            throw new ParsingException("Exception parsing show_entity hover", (Throwable)runtimeException, list);
        }
    }

    private HoverTransformation(HoverEvent.Action<Object> action, Object object) {
        this.action = action;
        this.value = object;
    }

    @Override
    public Component apply() {
        return Component.empty().hoverEvent(HoverEvent.hoverEvent(this.action, this.value));
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("action", this.action), ExaminableProperty.of("value", this.value));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HoverTransformation hoverTransformation = (HoverTransformation)object;
        return Objects.equals(this.action, hoverTransformation.action) && Objects.equals(this.value, hoverTransformation.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.action, this.value);
    }
}

