/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.stream.Stream;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.TextComponent;
import ld-shaded.net.kyori.adventure.text.flattener.ComponentFlattener;
import ld-shaded.net.kyori.adventure.text.format.NamedTextColor;
import ld-shaded.net.kyori.adventure.text.format.TextColor;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.ParsingException;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.ElementNode;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.TagNode;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.TagPart;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.ValueNode;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Modifying;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Transformation;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild.TemplateTransformation;
import ld-shaded.net.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;

public final class GradientTransformation
extends Transformation
implements Modifying {
    private int size = 0;
    private int disableApplyingColorDepth = -1;
    private int index = 0;
    private int colorIndex = 0;
    private float factorStep = 0.0f;
    private final TextColor[] colors;
    private float phase;
    private final boolean negativePhase;

    public static GradientTransformation create(String string, List<TagPart> list) {
        List<TextColor> list2;
        float f = 0.0f;
        if (!list.isEmpty()) {
            list2 = new ArrayList();
            for (int i = 0; i < list.size(); ++i) {
                TextColor textColor;
                String string2 = list.get(i).value();
                if (i == list.size() - 1) {
                    try {
                        f = Float.parseFloat(string2);
                        if (f < -1.0f || f > 1.0f) {
                            throw new ParsingException(String.format("Gradient phase is out of range (%s). Must be in the range [-1.0f, 1.0f] (inclusive).", Float.valueOf(f)), list);
                        }
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((textColor = string2.charAt(0) == '#' ? TextColor.fromHexString(string2) : (TextColor)NamedTextColor.NAMES.value(string2.toLowerCase(Locale.ROOT))) == null) {
                    throw new ParsingException(String.format("Unable to parse a color from '%s'. Please use named colours or hex (#RRGGBB) colors.", string2), list);
                }
                list2.add(textColor);
            }
            if (list2.size() < 2) {
                throw new ParsingException("Invalid gradient, not enough colors. Gradients must have at least two colors.", list);
            }
        } else {
            list2 = Collections.emptyList();
        }
        return new GradientTransformation(f, list2);
    }

    private GradientTransformation(float f, List<TextColor> list) {
        if (f < 0.0f) {
            this.negativePhase = true;
            this.phase = 1.0f + f;
            Collections.reverse(list);
        } else {
            this.negativePhase = false;
            this.phase = f;
        }
        this.colors = list.isEmpty() ? new TextColor[]{TextColor.color(0xFFFFFF), TextColor.color(0)} : list.toArray(new TextColor[0]);
    }

    @Override
    public void visit(ElementNode elementNode) {
        TagNode tagNode;
        if (elementNode instanceof ValueNode) {
            String string2 = ((ValueNode)elementNode).value();
            this.size += string2.codePointCount(0, string2.length());
        } else if (elementNode instanceof TagNode && (tagNode = (TagNode)elementNode).transformation() instanceof TemplateTransformation) {
            ComponentFlattener.textOnly().flatten(tagNode.transformation().apply(), string -> this.size += string.codePointCount(0, string.length()));
        }
    }

    @Override
    public Component apply() {
        int n = this.size / (this.colors.length - 1);
        if (n < 1) {
            n = 1;
        }
        this.factorStep = 1.0f / (float)(n + this.index);
        this.phase *= (float)n;
        this.index = 0;
        return Component.empty();
    }

    @Override
    public Component apply(Component component, int n) {
        if (this.disableApplyingColorDepth != -1 && n > this.disableApplyingColorDepth || component.style().color() != null) {
            if (this.disableApplyingColorDepth == -1) {
                this.disableApplyingColorDepth = n;
            }
            if (component instanceof TextComponent) {
                String string = ((TextComponent)component).content();
                int n2 = string.codePointCount(0, string.length());
                for (int i = 0; i < n2; ++i) {
                    this.color();
                }
            }
            return component.children(Collections.emptyList());
        }
        if (component instanceof TextComponent && ((TextComponent)component).content().length() > 0) {
            TextComponent textComponent = (TextComponent)component;
            String string = textComponent.content();
            TextComponent.Builder builder = Component.text();
            int[] nArray = new int[1];
            PrimitiveIterator.OfInt ofInt = string.codePoints().iterator();
            while (ofInt.hasNext()) {
                nArray[0] = ofInt.nextInt();
                TextComponent textComponent2 = Component.text(new String(nArray, 0, 1), this.color());
                builder.append((Component)textComponent2);
            }
            return builder.build();
        }
        return Component.empty().mergeStyle(component);
    }

    private TextColor color() {
        if (this.factorStep * (float)this.index > 1.0f) {
            ++this.colorIndex;
            this.index = 0;
        }
        int n = this.index++;
        float f = this.factorStep * ((float)n + this.phase);
        if (f > 1.0f) {
            f = 1.0f - (f - 1.0f);
        }
        if (this.negativePhase && this.colors.length % 2 != 0) {
            return TextColor.lerp(f, this.colors[this.colorIndex + 1], this.colors[this.colorIndex]);
        }
        return TextColor.lerp(f, this.colors[this.colorIndex], this.colors[this.colorIndex + 1]);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("phase", this.phase), ExaminableProperty.of("colors", this.colors));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GradientTransformation gradientTransformation = (GradientTransformation)object;
        return this.index == gradientTransformation.index && this.colorIndex == gradientTransformation.colorIndex && Float.compare(gradientTransformation.factorStep, this.factorStep) == 0 && this.phase == gradientTransformation.phase && Arrays.equals(this.colors, gradientTransformation.colors);
    }

    @Override
    public int hashCode() {
        int n = Objects.hash(this.index, this.colorIndex, Float.valueOf(this.factorStep), Float.valueOf(this.phase));
        n = 31 * n + Arrays.hashCode(this.colors);
        return n;
    }
}

