/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import ld-shaded.net.kyori.adventure.key.Key;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.format.Style;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.ParsingException;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.TagPart;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Transformation;
import ld-shaded.net.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;

public final class FontTransformation
extends Transformation {
    private final Key font;

    public static FontTransformation create(String string, List<TagPart> list) {
        Key key;
        if (list.size() == 1) {
            String string2 = list.get(0).value();
            key = Key.key(string2);
        } else if (list.size() == 2) {
            String string3 = list.get(0).value();
            String string4 = list.get(1).value();
            key = Key.key(string3, string4);
        } else {
            throw new ParsingException("Don't know how to turn " + list + " into a font", list);
        }
        return new FontTransformation(key);
    }

    private FontTransformation(Key key) {
        this.font = key;
    }

    @Override
    public Component apply() {
        return Component.empty().style(Style.style().font(this.font));
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("font", this.font));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FontTransformation fontTransformation = (FontTransformation)object;
        return Objects.equals(this.font, fontTransformation.font);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.font);
    }
}

