/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.format.TextDecoration;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.ParsingException;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.TagPart;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Transformation;
import ld-shaded.net.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DecorationTransformation
extends Transformation {
    public static final Map<String, TextDecoration> DECORATION_ALIASES;
    private final TextDecoration decoration;

    public static DecorationTransformation create(String string, List<TagPart> list) {
        @Nullable TextDecoration textDecoration = DecorationTransformation.parseDecoration(string);
        if (textDecoration == null) {
            throw new ParsingException("Don't know how to turn '" + string + "' into a decoration", list);
        }
        return new DecorationTransformation(textDecoration);
    }

    private static TextDecoration parseDecoration(String string) {
        TextDecoration textDecoration = DECORATION_ALIASES.get(string);
        return textDecoration != null ? textDecoration : TextDecoration.NAMES.value(string);
    }

    private DecorationTransformation(TextDecoration textDecoration) {
        this.decoration = textDecoration;
    }

    @Override
    public Component apply() {
        return Component.empty().decorate(this.decoration);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("decoration", this.decoration));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DecorationTransformation decorationTransformation = (DecorationTransformation)object;
        return this.decoration == decorationTransformation.decoration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.decoration);
    }

    static {
        HashMap<String, TextDecoration> hashMap = new HashMap<String, TextDecoration>();
        hashMap.put("b", TextDecoration.BOLD);
        hashMap.put("em", TextDecoration.ITALIC);
        hashMap.put("i", TextDecoration.ITALIC);
        hashMap.put("u", TextDecoration.UNDERLINED);
        hashMap.put("st", TextDecoration.STRIKETHROUGH);
        hashMap.put("obf", TextDecoration.OBFUSCATED);
        DECORATION_ALIASES = Collections.unmodifiableMap(hashMap);
    }
}

