/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.format.NamedTextColor;
import ld-shaded.net.kyori.adventure.text.format.TextColor;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.ParsingException;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.TagPart;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Transformation;
import ld-shaded.net.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;

public final class ColorTransformation
extends Transformation {
    private static final Map<String, TextColor> COLOR_ALIASES = new HashMap<String, TextColor>();
    private final TextColor color;

    private static boolean isColorOrAbbreviation(String string) {
        return string.equals("color") || string.equals("colour") || string.equals("c");
    }

    public static boolean canParse(String string) {
        return ColorTransformation.isColorOrAbbreviation(string) || TextColor.fromHexString(string) != null || NamedTextColor.NAMES.value(string) != null || COLOR_ALIASES.containsKey(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ColorTransformation create(String string, List<TagPart> list) {
        String string2;
        if (ColorTransformation.isColorOrAbbreviation(string)) {
            if (list.size() != 1) throw new ParsingException("Expected to find a color parameter, but found " + list, list);
            string2 = list.get(0).value().toLowerCase(Locale.ROOT);
        } else {
            string2 = string;
        }
        TextColor textColor = COLOR_ALIASES.containsKey(string2) ? COLOR_ALIASES.get(string2) : (string2.charAt(0) == '#' ? TextColor.fromHexString(string2) : (TextColor)NamedTextColor.NAMES.value(string2));
        if (textColor != null) return new ColorTransformation(textColor);
        throw new ParsingException("Don't know how to turn '" + string + "' into a color", list);
    }

    private ColorTransformation(TextColor textColor) {
        this.color = textColor;
    }

    @Override
    public Component apply() {
        return Component.empty().color(this.color);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("color", this.color));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ColorTransformation colorTransformation = (ColorTransformation)object;
        return Objects.equals(this.color, colorTransformation.color);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.color);
    }

    static {
        COLOR_ALIASES.put("dark_grey", NamedTextColor.DARK_GRAY);
        COLOR_ALIASES.put("grey", NamedTextColor.GRAY);
    }
}

