/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.event.ClickEvent;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.ParsingException;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.TagPart;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Transformation;
import ld-shaded.net.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClickTransformation
extends Transformation {
    private final ClickEvent.Action action;
    private final String value;

    public static ClickTransformation create(String string, List<TagPart> list) {
        if (list.size() != 2) {
            throw new ParsingException("Don't know how to turn " + list + " into a click event", list);
        }
        @Nullable ClickEvent.Action action = ClickEvent.Action.NAMES.value(list.get(0).value().toLowerCase(Locale.ROOT));
        String string2 = list.get(1).value();
        if (action == null) {
            throw new ParsingException("Unknown click event action '" + list.get(0).value() + "'", list);
        }
        return new ClickTransformation(action, string2);
    }

    private ClickTransformation(ClickEvent.Action action, String string) {
        this.action = action;
        this.value = string;
    }

    @Override
    public Component apply() {
        return Component.empty().clickEvent(ClickEvent.clickEvent(this.action, this.value));
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("action", (Object)this.action), ExaminableProperty.of("value", this.value));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ClickTransformation clickTransformation = (ClickTransformation)object;
        return this.action == clickTransformation.action && Objects.equals(this.value, clickTransformation.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.value});
    }
}

