/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage.transformation;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ld-shaded.net.kyori.adventure.text.format.TextDecoration;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Transformation;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.TransformationFactory;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.TransformationParser;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild.ClickTransformation;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild.ColorTransformation;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild.DecorationTransformation;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild.FontTransformation;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild.GradientTransformation;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild.HoverTransformation;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild.InsertionTransformation;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild.KeybindTransformation;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild.PreTransformation;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild.RainbowTransformation;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild.ResetTransformation;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild.TranslatableTransformation;

public final class TransformationType<T extends Transformation> {
    public static final TransformationType<?> COLOR = TransformationType.transformationType(ColorTransformation::canParse, ColorTransformation::create);
    public static final TransformationType<?> DECORATION = TransformationType.transformationType(TransformationType.acceptingNames(Stream.of(TextDecoration.NAMES.keys(), DecorationTransformation.DECORATION_ALIASES.keySet()).flatMap(Collection::stream).collect(Collectors.toSet())), DecorationTransformation::create);
    public static final TransformationType<?> HOVER_EVENT = TransformationType.transformationType(TransformationType.acceptingNames("hover"), HoverTransformation::create);
    public static final TransformationType<?> CLICK_EVENT = TransformationType.transformationType(TransformationType.acceptingNames("click"), ClickTransformation::create);
    public static final TransformationType<?> KEYBIND = TransformationType.transformationType(TransformationType.acceptingNames("key"), KeybindTransformation::create);
    public static final TransformationType<?> TRANSLATABLE = TransformationType.transformationType(TransformationType.acceptingNames("lang", "translate", "tr"), TranslatableTransformation::create);
    public static final TransformationType<?> INSERTION = TransformationType.transformationType(TransformationType.acceptingNames("insert"), InsertionTransformation::create);
    public static final TransformationType<?> FONT = TransformationType.transformationType(TransformationType.acceptingNames("font"), FontTransformation::create);
    public static final TransformationType<?> GRADIENT = TransformationType.transformationType(TransformationType.acceptingNames("gradient"), GradientTransformation::create);
    public static final TransformationType<?> RAINBOW = TransformationType.transformationType(TransformationType.acceptingNames("rainbow"), RainbowTransformation::create);
    @Deprecated
    public static final TransformationType<?> RESET = TransformationType.transformationType(TransformationType.acceptingNames("reset", "r"), ResetTransformation::create);
    @Deprecated
    public static final TransformationType<?> PRE = TransformationType.transformationType(TransformationType.acceptingNames("pre"), PreTransformation::create);
    final Predicate<String> canParse;
    final TransformationFactory<T> factory;

    @Deprecated
    public TransformationType(Predicate<String> predicate, TransformationParser<T> transformationParser) {
        this.canParse = predicate;
        this.factory = (context, string, list) -> {
            Object t = transformationParser.parse();
            ((Transformation)t).context(context);
            ((Transformation)t).load(string, list);
            return t;
        };
    }

    private TransformationType(Predicate<String> predicate, TransformationFactory<T> transformationFactory) {
        this.canParse = predicate;
        this.factory = transformationFactory;
    }

    public static <T extends Transformation> TransformationType<T> transformationType(Predicate<String> predicate, TransformationFactory<T> transformationFactory) {
        return new TransformationType<T>(Objects.requireNonNull(predicate, "nameMatcher"), Objects.requireNonNull(transformationFactory, "factory"));
    }

    public static <T extends Transformation> TransformationType<T> transformationType(Predicate<String> predicate, TransformationFactory.ContextFree<T> contextFree) {
        return new TransformationType<T>(Objects.requireNonNull(predicate, "nameMatcher"), Objects.requireNonNull(contextFree, "contextFreeFactory"));
    }

    public static Predicate<String> acceptingNames(String ... stringArray) {
        return TransformationType.acceptingNames(Arrays.asList(stringArray));
    }

    public static Predicate<String> acceptingNames(Collection<String> collection) {
        if (collection.size() == 1) {
            String string = collection.iterator().next().toLowerCase(Locale.ROOT);
            return string2 -> string2.equals(string);
        }
        HashSet<String> hashSet = new HashSet<String>(collection.size());
        for (String string : collection) {
            hashSet.add(string.toLowerCase(Locale.ROOT));
        }
        return hashSet::contains;
    }
}

