/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage.transformation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ld-shaded.net.kyori.adventure.text.minimessage.Context;
import ld-shaded.net.kyori.adventure.text.minimessage.Template;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.ParsingException;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.TagPart;
import ld-shaded.net.kyori.adventure.text.minimessage.template.TemplateResolver;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Transformation;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.TransformationFactory;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.TransformationRegistry;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.TransformationType;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild.TemplateTransformation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TransformationRegistryImpl
implements TransformationRegistry {
    private static final List<TransformationType<? extends Transformation>> DEFAULT_TRANSFORMATIONS = new ArrayList<TransformationType<? extends Transformation>>();
    static final TransformationRegistry EMPTY;
    static final TransformationRegistry STANDARD;
    private final List<TransformationType<? extends Transformation>> types;

    TransformationRegistryImpl(List<TransformationType<? extends Transformation>> list) {
        this.types = Collections.unmodifiableList(list);
    }

    private Transformation tryLoad(TransformationFactory<?> transformationFactory, String string, List<TagPart> list, Context context) {
        try {
            Object obj = transformationFactory.parse(context, string, list.subList(1, list.size()));
            ((Transformation)obj).context(context);
            ((Transformation)obj).load(string, list.subList(1, list.size()));
            return obj;
        }
        catch (ParsingException parsingException) {
            parsingException.originalText(context.originalMessage());
            throw parsingException;
        }
    }

    @Override
    @Nullable
    public Transformation get(String string, List<TagPart> list, TemplateResolver templateResolver, Context context) {
        Template template = templateResolver.resolve(string);
        if (template != null && template instanceof Template.ComponentTemplate) {
            return this.tryLoad(TemplateTransformation.factory(new Template.ComponentTemplate(string, ((Template.ComponentTemplate)template).value())), string, list, context);
        }
        for (TransformationType<? extends Transformation> transformationType : this.types) {
            if (!transformationType.canParse.test(string)) continue;
            return this.tryLoad(transformationType.factory, string, list, context);
        }
        return null;
    }

    @Override
    public boolean exists(String string, TemplateResolver templateResolver) {
        if (templateResolver.canResolve(string)) {
            return true;
        }
        for (TransformationType<? extends Transformation> transformationType : this.types) {
            if (!transformationType.canParse.test(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public TransformationRegistry.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static {
        DEFAULT_TRANSFORMATIONS.add(TransformationType.COLOR);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.DECORATION);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.HOVER_EVENT);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.CLICK_EVENT);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.KEYBIND);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.TRANSLATABLE);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.INSERTION);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.FONT);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.GRADIENT);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.RAINBOW);
        EMPTY = new TransformationRegistryImpl(Collections.emptyList());
        STANDARD = (TransformationRegistry)TransformationRegistry.builder().build();
    }

    static final class BuilderImpl
    implements TransformationRegistry.Builder {
        private final List<TransformationType<? extends Transformation>> types;

        BuilderImpl() {
            this.types = new ArrayList<TransformationType<? extends Transformation>>(DEFAULT_TRANSFORMATIONS);
        }

        BuilderImpl(TransformationRegistryImpl transformationRegistryImpl) {
            this.types = new ArrayList<TransformationType<? extends Transformation>>(transformationRegistryImpl.types);
        }

        @Override
        @NotNull
        public TransformationRegistry.Builder clear() {
            this.types.clear();
            return this;
        }

        @Override
        @NotNull
        public TransformationRegistry.Builder add(@NotNull TransformationType<? extends Transformation> transformationType) {
            this.types.add(transformationType);
            return this;
        }

        @Override
        @SafeVarargs
        @NotNull
        public final TransformationRegistry.Builder add(TransformationType<? extends Transformation> ... transformationTypeArray) {
            Collections.addAll(this.types, transformationTypeArray);
            return this;
        }

        @Override
        @NotNull
        public TransformationRegistry build() {
            return new TransformationRegistryImpl(this.types);
        }
    }
}

