/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage.template;

import ld-shaded.net.kyori.adventure.text.minimessage.Template;
import ld-shaded.net.kyori.adventure.text.minimessage.template.TemplateResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GroupedTemplateResolver
implements TemplateResolver {
    private final Iterable<? extends TemplateResolver> templateResolvers;

    GroupedTemplateResolver(@NotNull Iterable<? extends TemplateResolver> iterable) {
        this.templateResolvers = iterable;
    }

    @Override
    public boolean canResolve(@NotNull String string) {
        for (TemplateResolver templateResolver : this.templateResolvers) {
            if (!templateResolver.canResolve(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Template resolve(@NotNull String string) {
        for (TemplateResolver templateResolver : this.templateResolvers) {
            Template template = templateResolver.resolve(string);
            if (template == null) continue;
            return template;
        }
        return null;
    }
}

