/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage.template;

import java.util.function.Function;
import ld-shaded.net.kyori.adventure.text.ComponentLike;
import ld-shaded.net.kyori.adventure.text.minimessage.Template;
import ld-shaded.net.kyori.adventure.text.minimessage.template.TemplateResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DynamicTemplateResolver
implements TemplateResolver {
    private final Function<String, ?> resolver;

    DynamicTemplateResolver(Function<String, ?> function) {
        this.resolver = function;
    }

    @Override
    public boolean canResolve(@NotNull String string) {
        Object obj = this.resolver.apply(string);
        return obj instanceof String || obj instanceof ComponentLike || obj instanceof Template;
    }

    @Override
    @Nullable
    public Template resolve(@NotNull String string) {
        Object obj = this.resolver.apply(string);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return Template.template(string, (String)obj);
        }
        if (obj instanceof ComponentLike) {
            return Template.template(string, (ComponentLike)obj);
        }
        if (obj instanceof Template) {
            return (Template)obj;
        }
        throw new IllegalArgumentException("Dynamic template resolver must return instances of String or ComponentLike, instead found " + obj.getClass().getName());
    }
}

