/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage.parser.node;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import ld-shaded.net.kyori.adventure.text.minimessage.Template;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.ParsingException;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.Token;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.ElementNode;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.TagPart;
import ld-shaded.net.kyori.adventure.text.minimessage.template.TemplateResolver;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Transformation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TagNode
extends ElementNode {
    private final List<TagPart> parts;
    @Nullable
    private Transformation transformation = null;

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public TagNode(@NotNull ElementNode elementNode, @NotNull Token token, @NotNull String string, @NotNull Map<String, Template> map) {
        this(elementNode, token, string, TemplateResolver.pairs(map));
    }

    public TagNode(@NotNull ElementNode elementNode, @NotNull Token token, @NotNull String string, @NotNull TemplateResolver templateResolver) {
        super(elementNode, token, string);
        this.parts = TagNode.genParts(token, string, templateResolver);
    }

    @NotNull
    private static List<TagPart> genParts(@NotNull Token token, @NotNull String string, @NotNull TemplateResolver templateResolver) {
        ArrayList<TagPart> arrayList = new ArrayList<TagPart>();
        if (token.childTokens() != null) {
            for (Token token2 : token.childTokens()) {
                arrayList.add(new TagPart(string, token2, templateResolver));
            }
        }
        return arrayList;
    }

    @NotNull
    public List<TagPart> parts() {
        return this.parts;
    }

    @NotNull
    public String name() {
        if (this.parts.isEmpty()) {
            throw new ParsingException("Tag has no parts? " + this, this.sourceMessage(), this.token());
        }
        return this.parts.get(0).value();
    }

    @Override
    @NotNull
    public Token token() {
        return Objects.requireNonNull(super.token(), "token is not set");
    }

    @NotNull
    public Transformation transformation() {
        return Objects.requireNonNull(this.transformation, "no transformation set");
    }

    public void transformation(@NotNull Transformation transformation) {
        this.transformation = transformation;
    }

    @Override
    @NotNull
    public StringBuilder buildToString(@NotNull StringBuilder stringBuilder, int n) {
        char[] cArray = this.ident(n);
        stringBuilder.append(cArray).append("TagNode(");
        int n2 = this.parts.size();
        for (int i = 0; i < n2; ++i) {
            TagPart object = this.parts.get(i);
            stringBuilder.append('\'').append(object.value()).append('\'');
            if (i == n2 - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(") {\n");
        for (ElementNode elementNode : this.children()) {
            elementNode.buildToString(stringBuilder, n + 1);
        }
        stringBuilder.append(cArray).append("}\n");
        return stringBuilder;
    }
}

