/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.IntPredicate;
import ld-shaded.net.kyori.adventure.text.minimessage.Template;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.ParsingException;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.Token;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.TokenType;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.ElementNode;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.RootNode;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.TagNode;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.TagPart;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.TemplateNode;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.TextNode;
import ld-shaded.net.kyori.adventure.text.minimessage.template.TemplateResolver;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Inserting;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Transformation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TokenParser {
    private TokenParser() {
    }

    public static ElementNode parse(@NotNull Function<TagNode, @Nullable Transformation> function, @NotNull BiPredicate<String, Boolean> biPredicate, @NotNull TemplateResolver templateResolver, @NotNull String string, boolean bl) {
        List<Token> list = TokenParser.tokenize(string);
        return TokenParser.buildTree(function, biPredicate, templateResolver, list, string, bl);
    }

    public static List<Token> tokenize(String string) {
        List<Token> list = TokenParser.parseFirstPass(string);
        TokenParser.parseSecondPass(string, list);
        return list;
    }

    private static List<Token> parseFirstPass(String string) {
        int n;
        ArrayList<Token> arrayList = new ArrayList<Token>();
        FirstPassState firstPassState = FirstPassState.NORMAL;
        boolean bl = false;
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        int n5 = string.length();
        block15: for (n = 0; n < n5; ++n) {
            int n6 = string.codePointAt(n);
            if (!Character.isBmpCodePoint(n6)) {
                ++n;
            }
            if (!bl) {
                if (n6 == 92 && n + 1 < string.length()) {
                    int n7 = string.codePointAt(n + 1);
                    switch (firstPassState) {
                        case NORMAL: {
                            bl = n7 == 60;
                            break;
                        }
                        case STRING: {
                            bl = n4 == n7;
                            break;
                        }
                    }
                    if (bl) {
                        continue;
                    }
                }
            } else {
                bl = false;
                continue;
            }
            switch (firstPassState) {
                case NORMAL: {
                    if (n6 != 60) continue block15;
                    n3 = n;
                    firstPassState = FirstPassState.TAG;
                    continue block15;
                }
                case TAG: {
                    switch (n6) {
                        case 62: {
                            if (n == n3 + 1) {
                                firstPassState = FirstPassState.NORMAL;
                                break;
                            }
                            if (n2 != n3) {
                                arrayList.add(new Token(n2, n3, TokenType.TEXT));
                            }
                            n2 = n + 1;
                            TokenType tokenType = TokenType.OPEN_TAG;
                            if (TokenParser.boundsCheck(string, n3, 1) && string.charAt(n3 + 1) == '/') {
                                tokenType = TokenType.CLOSE_TAG;
                            }
                            arrayList.add(new Token(n3, n2, tokenType));
                            if (string.regionMatches(n3, "<pre>", 0, 5)) {
                                firstPassState = FirstPassState.PRE;
                                break;
                            }
                            firstPassState = FirstPassState.NORMAL;
                            break;
                        }
                        case 60: {
                            n3 = n;
                            break;
                        }
                        case 34: 
                        case 39: {
                            firstPassState = FirstPassState.STRING;
                            n4 = (char)n6;
                        }
                    }
                    continue block15;
                }
                case PRE: {
                    if (n6 != 60 || !string.regionMatches(n, "</pre>", 0, 6)) continue block15;
                    arrayList.add(new Token(n2, n, TokenType.TEXT));
                    arrayList.add(new Token(n, n + 6, TokenType.CLOSE_TAG));
                    n2 = (n += 5) + 1;
                    firstPassState = FirstPassState.NORMAL;
                    continue block15;
                }
                case STRING: {
                    if (n6 != n4) continue block15;
                    firstPassState = FirstPassState.TAG;
                }
            }
        }
        if (arrayList.isEmpty()) {
            arrayList.add(new Token(0, string.length(), TokenType.TEXT));
        } else {
            n = ((Token)arrayList.get(arrayList.size() - 1)).endIndex();
            if (n != string.length()) {
                arrayList.add(new Token(n, string.length(), TokenType.TEXT));
            }
        }
        return arrayList;
    }

    private static void parseSecondPass(String string, List<Token> list) {
        for (Token token : list) {
            int n;
            TokenType tokenType = token.type();
            if (tokenType != TokenType.OPEN_TAG && tokenType != TokenType.CLOSE_TAG) continue;
            int n2 = tokenType == TokenType.OPEN_TAG ? token.startIndex() + 1 : token.startIndex() + 2;
            int n3 = token.endIndex() - 1;
            SecondPassState secondPassState = SecondPassState.NORMAL;
            boolean bl = false;
            int n4 = 0;
            int n5 = n2;
            block9: for (n = n2; n < n3; ++n) {
                int n6 = string.codePointAt(n);
                if (!Character.isBmpCodePoint(n)) {
                    ++n;
                }
                if (!bl) {
                    if (n6 == 92 && n + 1 < string.length()) {
                        int n7 = string.codePointAt(n + 1);
                        switch (secondPassState) {
                            case NORMAL: {
                                bl = n7 == 60;
                                break;
                            }
                            case STRING: {
                                boolean bl2 = bl = n4 == n7;
                            }
                        }
                        if (bl) {
                            continue;
                        }
                    }
                } else {
                    bl = false;
                    continue;
                }
                switch (secondPassState) {
                    case NORMAL: {
                        if (n6 == 58) {
                            if (TokenParser.boundsCheck(string, n, 2) && string.charAt(n + 1) == '/' && string.charAt(n + 2) == '/') continue block9;
                            if (n5 == n) {
                                TokenParser.insert(token, new Token(n, n, TokenType.TAG_VALUE));
                                ++n5;
                                continue block9;
                            }
                            TokenParser.insert(token, new Token(n5, n, TokenType.TAG_VALUE));
                            n5 = n + 1;
                            continue block9;
                        }
                        if (n6 != 39 && n6 != 34) continue block9;
                        secondPassState = SecondPassState.STRING;
                        n4 = (char)n6;
                        continue block9;
                    }
                    case STRING: {
                        if (n6 != n4) continue block9;
                        secondPassState = SecondPassState.NORMAL;
                    }
                }
            }
            if (token.childTokens() == null || token.childTokens().isEmpty()) {
                TokenParser.insert(token, new Token(n2, n3, TokenType.TAG_VALUE));
                continue;
            }
            n = token.childTokens().get(token.childTokens().size() - 1).endIndex();
            if (n == n3) continue;
            TokenParser.insert(token, new Token(n + 1, n3, TokenType.TAG_VALUE));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static ElementNode buildTree(@NotNull Function<TagNode, @Nullable Transformation> function, @NotNull BiPredicate<String, Boolean> biPredicate, @NotNull TemplateResolver templateResolver, @NotNull List<Token> list, @NotNull String string, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        RootNode rootNode = new RootNode(string);
        ElementNode elementNode = rootNode;
        for (Token tokenArray : list) {
            object3 = tokenArray.type();
            switch (1.$SwitchMap$net$kyori$adventure$text$minimessage$parser$TokenType[((Enum)object3).ordinal()]) {
                case 1: {
                    elementNode.addChild(new TextNode(elementNode, tokenArray, string));
                    break;
                }
                case 2: {
                    TagNode tagNode = new TagNode(elementNode, tokenArray, string, templateResolver);
                    if (TokenParser.isReset(tagNode.name())) {
                        if (bl) {
                            throw new ParsingException("<reset> tags are not allowed when strict mode is enabled", string, tokenArray);
                        }
                        elementNode = rootNode;
                        break;
                    }
                    if (tagNode.name().equals("pre")) break;
                    object2 = templateResolver.resolve(tagNode.name());
                    if (object2 instanceof Template.StringTemplate) {
                        elementNode.addChild(new TemplateNode(elementNode, tokenArray, string, ((Template.StringTemplate)object2).value()));
                        break;
                    }
                    if (biPredicate.test(tagNode.name(), true)) {
                        object = function.apply(tagNode);
                        if (object == null) {
                            elementNode.addChild(new TextNode(elementNode, tokenArray, string));
                            break;
                        }
                        tagNode.transformation((Transformation)object);
                        elementNode.addChild(tagNode);
                        if (object instanceof Inserting) break;
                        elementNode = tagNode;
                        break;
                    }
                    elementNode.addChild(new TextNode(elementNode, tokenArray, string));
                    break;
                }
                case 3: {
                    Object object4;
                    object2 = tokenArray.childTokens();
                    if (object2.isEmpty()) {
                        throw new IllegalStateException("CLOSE_TAG token somehow has no children - the parser should not allow this. Original text: " + string);
                    }
                    object = new ArrayList<String>(object2.size());
                    Object object5 = object2.iterator();
                    while (object5.hasNext()) {
                        object4 = object5.next();
                        ((ArrayList)object).add(TagPart.unquoteAndEscape(string, ((Token)object4).startIndex(), ((Token)object4).endIndex()));
                    }
                    object5 = (String)((ArrayList)object).get(0);
                    if (TokenParser.isReset((String)object5) || ((String)object5).equals("pre")) break;
                    if (!biPredicate.test((String)object5, false)) {
                        elementNode.addChild(new TextNode(elementNode, tokenArray, string));
                        break;
                    }
                    object4 = elementNode;
                    while (object4 instanceof TagNode) {
                        List<TagPart> list2 = ((TagNode)object4).parts();
                        if (TokenParser.tagCloses((List<String>)object, list2)) {
                            Object object6;
                            if (object4 != elementNode && bl) {
                                object6 = "Unclosed tag encountered; " + ((TagNode)elementNode).name() + " is not closed, because " + (String)((ArrayList)object).get(0) + " was closed first.";
                                throw new ParsingException((String)object6, string, ((ElementNode)object4).token(), elementNode.token(), tokenArray);
                            }
                            object6 = ((ElementNode)object4).parent();
                            if (object6 != null) {
                                elementNode = object6;
                                break;
                            }
                            throw new IllegalStateException("Root node matched with close tag value, this should not be possible. Original text: " + string);
                        }
                        object4 = ((ElementNode)object4).parent();
                    }
                    if (object4 != null && !(object4 instanceof RootNode)) break;
                    elementNode.addChild(new TextNode(elementNode, tokenArray, string));
                }
            }
        }
        if (bl && rootNode != elementNode) {
            void var9_11;
            ArrayList arrayList = new ArrayList();
            RootNode rootNode2 = elementNode;
            while (var9_11 != null && var9_11 instanceof TagNode) {
                arrayList.add((TagNode)var9_11);
                ElementNode elementNode2 = var9_11.parent();
            }
            Token[] tokenArray = new Token[arrayList.size()];
            object3 = new StringBuilder("All tags must be explicitly closed while in strict mode. End of string found with open tags: ");
            int n = 0;
            object2 = arrayList.listIterator(arrayList.size());
            while (object2.hasPrevious()) {
                object = (TagNode)object2.previous();
                tokenArray[n++] = ((TagNode)object).token();
                ((StringBuilder)object3).append(((TagNode)object).name());
                if (!object2.hasPrevious()) continue;
                ((StringBuilder)object3).append(", ");
            }
            throw new ParsingException(((StringBuilder)object3).toString(), string, tokenArray);
        }
        return rootNode;
    }

    public static String resolveStringTemplates(@NotNull String string, @NotNull TemplateResolver templateResolver) {
        List<Token> list = TokenParser.tokenize(string);
        StringBuilder stringBuilder = new StringBuilder();
        for (Token token : list) {
            TokenType tokenType = token.type();
            switch (tokenType) {
                case TEXT: 
                case CLOSE_TAG: {
                    stringBuilder.append(token.get(string));
                    break;
                }
                case OPEN_TAG: {
                    CharSequence charSequence;
                    Template template;
                    if (token.childTokens() != null && token.childTokens().size() == 1 && (template = templateResolver.resolve((charSequence = token.childTokens().get(0).get(string)).toString().toLowerCase(Locale.ROOT))) instanceof Template.StringTemplate) {
                        stringBuilder.append(((Template.StringTemplate)template).value());
                        break;
                    }
                    stringBuilder.append(token.get(string));
                }
            }
        }
        return stringBuilder.toString();
    }

    private static boolean isReset(String string) {
        return string.equalsIgnoreCase("reset") || string.equalsIgnoreCase("r");
    }

    private static boolean tagCloses(List<String> list, List<TagPart> list2) {
        if (list.size() > list2.size()) {
            return false;
        }
        if (!list.get(0).equalsIgnoreCase(list2.get(0).value())) {
            return false;
        }
        for (int i = 1; i < list.size(); ++i) {
            if (list.get(i).equals(list2.get(i).value())) continue;
            return false;
        }
        return true;
    }

    private static boolean boundsCheck(String string, int n, int n2) {
        return n + n2 < string.length();
    }

    private static void insert(Token token, Token token2) {
        if (token.childTokens() == null) {
            token.childTokens(Collections.singletonList(token2));
            return;
        }
        if (token.childTokens().size() == 1) {
            ArrayList<Token> arrayList = new ArrayList<Token>(3);
            arrayList.add(token.childTokens().get(0));
            arrayList.add(token2);
            token.childTokens(arrayList);
        } else {
            token.childTokens().add(token2);
        }
    }

    public static String unescape(String string, int n, int n2, IntPredicate intPredicate) {
        int n3 = n;
        int n4 = string.indexOf(92, n3);
        if (n4 == -1 || n4 >= n2) {
            return string.substring(n3, n2);
        }
        StringBuilder stringBuilder = new StringBuilder(n2 - n);
        while (n4 != -1 && n4 + 1 < n2) {
            if (intPredicate.test(string.codePointAt(n4 + 1))) {
                stringBuilder.append(string, n3, n4);
                if (++n4 >= n2) {
                    n3 = n2;
                    break;
                }
                int n5 = string.codePointAt(n4);
                stringBuilder.appendCodePoint(n5);
                n4 = Character.isBmpCodePoint(n5) ? ++n4 : (n4 += 2);
                if (n4 >= n2) {
                    n3 = n2;
                    break;
                }
            } else {
                stringBuilder.append(string, n3, ++n4);
            }
            n3 = n4;
            n4 = string.indexOf(92, n3);
        }
        stringBuilder.append(string, n3, n2);
        return stringBuilder.toString();
    }

    static enum SecondPassState {
        NORMAL,
        STRING;

    }

    static enum FirstPassState {
        NORMAL,
        TAG,
        PRE,
        STRING;

    }
}

