/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage.parser;

import java.util.Arrays;
import java.util.List;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.Token;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.TagPart;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParsingException
extends RuntimeException {
    private static final long serialVersionUID = 2507190809441787201L;
    @Nullable
    private String originalText;
    private Token @NotNull [] tokens;

    public ParsingException(String string, @Nullable String string2, @NotNull List<TagPart> list) {
        this(string, string2, ParsingException.tagsToTokens(list));
    }

    public ParsingException(String string, @Nullable String string2, Token ... tokenArray) {
        super(string);
        this.tokens = tokenArray;
        this.originalText = string2;
    }

    public ParsingException(String string, @Nullable String string2, @Nullable Throwable throwable, @NotNull List<TagPart> list) {
        this(string, string2, throwable, ParsingException.tagsToTokens(list));
    }

    public ParsingException(String string, @Nullable String string2, @Nullable Throwable throwable, Token ... tokenArray) {
        super(string, throwable);
        this.tokens = tokenArray;
        this.originalText = string2;
    }

    public ParsingException(String string, List<TagPart> list) {
        this(string, ParsingException.tagsToTokens(list));
    }

    public ParsingException(String string, Token ... tokenArray) {
        this(string, (String)null, (Throwable)null, tokenArray);
    }

    public ParsingException(String string, @Nullable Throwable throwable, @NotNull List<TagPart> list) {
        this(string, null, throwable, ParsingException.tagsToTokens(list));
    }

    public ParsingException(String string, @Nullable Throwable throwable, Token ... tokenArray) {
        this(string, null, throwable, tokenArray);
    }

    @Override
    public String getMessage() {
        String string = this.tokens().length != 0 ? "\n\t" + this.arrow() : "";
        String string2 = this.originalText() != null ? "\n\t" + this.originalText() + string : "";
        return super.getMessage() + string2;
    }

    @Nullable
    public String originalText() {
        return this.originalText;
    }

    public void originalText(@NotNull String string) {
        this.originalText = string;
    }

    @NotNull
    public @NotNull Token @NotNull [] tokens() {
        return this.tokens;
    }

    public void tokens(@NotNull @NotNull Token @NotNull [] tokenArray) {
        this.tokens = tokenArray;
    }

    private String arrow() {
        @NotNull Token[] tokenArray = this.tokens();
        char[] cArray = new char[tokenArray[tokenArray.length - 1].endIndex()];
        int n = 0;
        for (Token token : tokenArray) {
            Arrays.fill(cArray, n, token.startIndex(), ' ');
            cArray[token.startIndex()] = 94;
            Arrays.fill(cArray, token.startIndex() + 1, token.endIndex() - 1, '~');
            cArray[token.endIndex() - 1] = 94;
            n = token.endIndex();
        }
        return new String(cArray);
    }

    private static Token[] tagsToTokens(List<TagPart> list) {
        Token[] tokenArray = new Token[list.size()];
        int n = tokenArray.length;
        for (int i = 0; i < n; ++i) {
            tokenArray[i] = list.get(i).token();
        }
        return tokenArray;
    }
}

