/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage;

import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.ComponentLike;
import ld-shaded.net.kyori.examination.Examinable;
import ld-shaded.net.kyori.examination.ExaminableProperty;
import ld-shaded.net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface Template
extends Examinable {
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static Template of(@NotNull String key, @NotNull String value) {
        return new StringTemplate(Objects.requireNonNull(key, "key"), Objects.requireNonNull(value, "value"));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static Template of(@NotNull String key, @NotNull Component value) {
        return new ComponentTemplate(Objects.requireNonNull(key, "key"), Objects.requireNonNull(value, "value"));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static Template of(@NotNull String key, @NotNull Supplier<Component> value) {
        return new LazyComponentTemplate(Objects.requireNonNull(key, "key"), Objects.requireNonNull(value, "value"));
    }

    @NotNull
    public static Template template(@NotNull String key, @NotNull String value) {
        return new StringTemplate(Objects.requireNonNull(key, "key"), Objects.requireNonNull(value, "value"));
    }

    @NotNull
    public static Template template(@NotNull String key, @NotNull ComponentLike value) {
        return new ComponentTemplate(Objects.requireNonNull(key, "key"), Objects.requireNonNull(Objects.requireNonNull(value, "value").asComponent(), "value cannot resolve to null"));
    }

    @NotNull
    public static Template template(@NotNull String key, @NotNull Supplier<? extends ComponentLike> value) {
        return new LazyComponentTemplate(Objects.requireNonNull(key, "key"), Objects.requireNonNull(value, "value"));
    }

    @NotNull
    public String key();

    @NotNull
    public Object value();

    @ApiStatus.Internal
    public static class LazyComponentTemplate
    extends ComponentTemplate {
        @NotNull
        private final Supplier<? extends ComponentLike> value;

        public LazyComponentTemplate(@NotNull String string, @NotNull Supplier<? extends ComponentLike> supplier) {
            super(string, Component.empty());
            this.value = supplier;
        }

        @Override
        @NotNull
        public Component value() {
            return Objects.requireNonNull(Objects.requireNonNull(this.value.get(), () -> "get() value of " + this.value).asComponent(), () -> "asComponent() on value of " + this.value);
        }

        @Override
        @NotNull
        public Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of("key", this.key()), ExaminableProperty.of("value", this.value));
        }
    }

    @ApiStatus.Internal
    public static class ComponentTemplate
    implements Template {
        @NotNull
        private final String key;
        @NotNull
        private final Component value;

        public ComponentTemplate(@NotNull String string, @NotNull Component component) {
            if (!string.toLowerCase(Locale.ROOT).equals(string)) {
                throw new IllegalArgumentException("Template key '" + string + "' must be lowercase");
            }
            this.key = string;
            this.value = component;
        }

        @Override
        @NotNull
        public String key() {
            return this.key;
        }

        @Override
        @NotNull
        public Component value() {
            return this.value;
        }

        public final String toString() {
            return this.examine(StringExaminer.simpleEscaping());
        }

        @Override
        @NotNull
        public Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of("key", this.key), ExaminableProperty.of("value", this.value));
        }
    }

    @ApiStatus.Internal
    public static class StringTemplate
    implements Template {
        private final String key;
        private final String value;

        StringTemplate(@NotNull String string, @NotNull String string2) {
            if (!string.toLowerCase(Locale.ROOT).equals(string)) {
                throw new IllegalArgumentException("Template key '" + string + "' must be lowercase");
            }
            this.key = string;
            this.value = string2;
        }

        @Override
        @NotNull
        public String key() {
            return this.key;
        }

        @Override
        @NotNull
        public String value() {
            return this.value;
        }

        public final String toString() {
            return this.examine(StringExaminer.simpleEscaping());
        }

        @Override
        @NotNull
        public Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of("key", this.key), ExaminableProperty.of("value", this.value));
        }
    }
}

