/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import ld-shaded.net.kyori.adventure.key.Key;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.KeybindComponent;
import ld-shaded.net.kyori.adventure.text.TextComponent;
import ld-shaded.net.kyori.adventure.text.TranslatableComponent;
import ld-shaded.net.kyori.adventure.text.event.ClickEvent;
import ld-shaded.net.kyori.adventure.text.event.HoverEvent;
import ld-shaded.net.kyori.adventure.text.format.NamedTextColor;
import ld-shaded.net.kyori.adventure.text.format.Style;
import ld-shaded.net.kyori.adventure.text.format.TextColor;
import ld-shaded.net.kyori.adventure.text.format.TextDecoration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MiniMessageSerializer {
    private MiniMessageSerializer() {
    }

    @NotNull
    static String serialize(@NotNull Component component) {
        List<ComponentNode> list = MiniMessageSerializer.traverseNode(new ComponentNode(component));
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            Style style = i - 1 >= 0 ? list.get(i - 1).style() : null;
            Style style2 = i + 1 < list.size() ? list.get(i + 1).style() : null;
            ComponentNode componentNode = list.get(i);
            stringBuilder.append(MiniMessageSerializer.serializeNode(componentNode, style, style2));
        }
        return stringBuilder.toString();
    }

    private static List<ComponentNode> traverseNode(@NotNull ComponentNode componentNode) {
        LinkedList<ComponentNode> linkedList = new LinkedList<ComponentNode>();
        linkedList.add(componentNode);
        if (!componentNode.component().children().isEmpty()) {
            for (Component component : componentNode.component().children()) {
                linkedList.addAll(MiniMessageSerializer.traverseNode(new ComponentNode(component, componentNode.style())));
            }
        }
        return linkedList;
    }

    private static String serializeNode(@NotNull ComponentNode componentNode, @Nullable Style style, @Nullable Style style2) {
        Key key;
        String string;
        ClickEvent clickEvent;
        HoverEvent<?> hoverEvent;
        StringBuilder stringBuilder = new StringBuilder();
        Style style3 = componentNode.style();
        if (style3.color() != null && (style == null || style.color() != style3.color())) {
            stringBuilder.append(MiniMessageSerializer.startColor(Objects.requireNonNull(style3.color())));
        }
        if (style3.hasDecoration(TextDecoration.BOLD) && (style == null || !style.hasDecoration(TextDecoration.BOLD))) {
            stringBuilder.append(MiniMessageSerializer.startTag("bold"));
        }
        if (style3.hasDecoration(TextDecoration.ITALIC) && (style == null || !style.hasDecoration(TextDecoration.ITALIC))) {
            stringBuilder.append(MiniMessageSerializer.startTag("italic"));
        }
        if (style3.hasDecoration(TextDecoration.OBFUSCATED) && (style == null || !style.hasDecoration(TextDecoration.OBFUSCATED))) {
            stringBuilder.append(MiniMessageSerializer.startTag("obfuscated"));
        }
        if (style3.hasDecoration(TextDecoration.STRIKETHROUGH) && (style == null || !style.hasDecoration(TextDecoration.STRIKETHROUGH))) {
            stringBuilder.append(MiniMessageSerializer.startTag("strikethrough"));
        }
        if (style3.hasDecoration(TextDecoration.UNDERLINED) && (style == null || !style.hasDecoration(TextDecoration.UNDERLINED))) {
            stringBuilder.append(MiniMessageSerializer.startTag("underlined"));
        }
        if ((hoverEvent = style3.hoverEvent()) != null && (style == null || MiniMessageSerializer.areDifferent(hoverEvent, style.hoverEvent()))) {
            MiniMessageSerializer.serializeHoverEvent(stringBuilder, hoverEvent);
        }
        if ((clickEvent = style3.clickEvent()) != null && (style == null || MiniMessageSerializer.areDifferent(clickEvent, style.clickEvent()))) {
            stringBuilder.append(MiniMessageSerializer.startTag(String.format("%s:%s:\"%s\"", "click", ClickEvent.Action.NAMES.key(clickEvent.action()), clickEvent.value())));
        }
        if (!((string = style3.insertion()) == null || style != null && string.equals(style.insertion()))) {
            stringBuilder.append(MiniMessageSerializer.startTag("insert:" + string));
        }
        if (!((key = style3.font()) == null || style != null && key.equals(style.font()))) {
            stringBuilder.append(MiniMessageSerializer.startTag("font:" + key.asString()));
        }
        if (componentNode.component() instanceof TextComponent) {
            stringBuilder.append(((TextComponent)componentNode.component()).content());
        } else {
            MiniMessageSerializer.handleDifferentComponent(componentNode.component(), stringBuilder);
        }
        if (style2 != null && style3.font() != null && !Objects.equals(style3.font(), style2.font())) {
            stringBuilder.append(MiniMessageSerializer.endTag("font"));
        }
        if (style2 != null && style3.insertion() != null && !Objects.equals(style3.insertion(), style2.insertion())) {
            stringBuilder.append(MiniMessageSerializer.endTag("insert"));
        }
        if (style2 != null && style3.clickEvent() != null && MiniMessageSerializer.areDifferent(Objects.requireNonNull(style3.clickEvent()), style2.clickEvent())) {
            stringBuilder.append(MiniMessageSerializer.endTag("click"));
        }
        if (style2 != null && style3.hoverEvent() != null && MiniMessageSerializer.areDifferent(Objects.requireNonNull(style3.hoverEvent()), style2.hoverEvent())) {
            stringBuilder.append(MiniMessageSerializer.endTag("hover"));
        }
        if (style2 != null) {
            if (style3.hasDecoration(TextDecoration.UNDERLINED) && !style2.hasDecoration(TextDecoration.UNDERLINED)) {
                stringBuilder.append(MiniMessageSerializer.endTag("underlined"));
            }
            if (style3.hasDecoration(TextDecoration.STRIKETHROUGH) && !style2.hasDecoration(TextDecoration.STRIKETHROUGH)) {
                stringBuilder.append(MiniMessageSerializer.endTag("strikethrough"));
            }
            if (style3.hasDecoration(TextDecoration.OBFUSCATED) && !style2.hasDecoration(TextDecoration.OBFUSCATED)) {
                stringBuilder.append(MiniMessageSerializer.endTag("obfuscated"));
            }
            if (style3.hasDecoration(TextDecoration.ITALIC) && !style2.hasDecoration(TextDecoration.ITALIC)) {
                stringBuilder.append(MiniMessageSerializer.endTag("italic"));
            }
            if (style3.hasDecoration(TextDecoration.BOLD) && !style2.hasDecoration(TextDecoration.BOLD)) {
                stringBuilder.append(MiniMessageSerializer.endTag("bold"));
            }
        }
        if (style2 != null && style3.color() != null && style2.color() != style3.color()) {
            stringBuilder.append(MiniMessageSerializer.endColor(Objects.requireNonNull(style3.color())));
        }
        return stringBuilder.toString();
    }

    private static void serializeHoverEvent(@NotNull StringBuilder stringBuilder, @NotNull HoverEvent<?> hoverEvent) {
        if (hoverEvent.action() == HoverEvent.Action.SHOW_TEXT) {
            stringBuilder.append(MiniMessageSerializer.startTag("hover:" + HoverEvent.Action.NAMES.key(hoverEvent.action()) + ':' + "\"" + MiniMessageSerializer.serialize((Component)hoverEvent.value()).replace("\"", "\\\"") + "\""));
        } else if (hoverEvent.action() == HoverEvent.Action.SHOW_ITEM) {
            HoverEvent.ShowItem showItem = (HoverEvent.ShowItem)hoverEvent.value();
            String string = showItem.nbt() != null ? ":\"" + showItem.nbt().string().replace("\"", "\\\"") + "\"" : "";
            stringBuilder.append(MiniMessageSerializer.startTag("hover:" + HoverEvent.Action.NAMES.key(hoverEvent.action()) + ':' + "'" + showItem.item().asString() + "'" + ':' + showItem.count() + string));
        } else if (hoverEvent.action() == HoverEvent.Action.SHOW_ENTITY) {
            HoverEvent.ShowEntity showEntity = (HoverEvent.ShowEntity)hoverEvent.value();
            String string = showEntity.name() != null ? ":\"" + MiniMessageSerializer.serialize(showEntity.name()).replace("\"", "\\\"") + "\"" : "";
            stringBuilder.append(MiniMessageSerializer.startTag("hover:" + HoverEvent.Action.NAMES.key(hoverEvent.action()) + ':' + "'" + showEntity.type().asString() + "'" + ':' + showEntity.id() + string));
        } else {
            throw new RuntimeException("Don't know how to serialize '" + hoverEvent + "'!");
        }
    }

    private static boolean areDifferent(@NotNull ClickEvent clickEvent, @Nullable ClickEvent clickEvent2) {
        if (clickEvent2 == null) {
            return true;
        }
        return !clickEvent.equals(clickEvent2) && (!clickEvent.action().equals((Object)clickEvent2.action()) || !clickEvent.value().equals(clickEvent2.value()));
    }

    private static boolean areDifferent(@NotNull HoverEvent<?> hoverEvent, @Nullable HoverEvent<?> hoverEvent2) {
        if (hoverEvent2 == null) {
            return true;
        }
        return !hoverEvent.equals(hoverEvent2) && !hoverEvent.action().equals(hoverEvent2.action());
    }

    @NotNull
    private static String startColor(@NotNull TextColor textColor) {
        if (textColor instanceof NamedTextColor) {
            return MiniMessageSerializer.startTag(Objects.requireNonNull(NamedTextColor.NAMES.key((NamedTextColor)textColor)));
        }
        return MiniMessageSerializer.startTag("color:" + textColor.asHexString());
    }

    @NotNull
    private static String endColor(@NotNull TextColor textColor) {
        if (textColor instanceof NamedTextColor) {
            return MiniMessageSerializer.endTag(Objects.requireNonNull(NamedTextColor.NAMES.key((NamedTextColor)textColor)));
        }
        return MiniMessageSerializer.endTag("color:" + textColor.asHexString());
    }

    @NotNull
    private static String startTag(@NotNull String string) {
        return "<" + string + '>';
    }

    @NotNull
    private static String endTag(@NotNull String string) {
        return "</" + string + '>';
    }

    private static void handleDifferentComponent(@NotNull Component component, @NotNull StringBuilder stringBuilder) {
        if (component instanceof KeybindComponent) {
            stringBuilder.append(MiniMessageSerializer.startTag("key:" + ((KeybindComponent)component).keybind()));
        } else if (component instanceof TranslatableComponent) {
            StringBuilder stringBuilder2 = new StringBuilder();
            for (Component component2 : ((TranslatableComponent)component).args()) {
                stringBuilder2.append(':').append("\"").append(MiniMessageSerializer.serialize(component2).replace("\"", "\\\"")).append("\"");
            }
            stringBuilder.append(MiniMessageSerializer.startTag("lang:" + ((TranslatableComponent)component).key() + stringBuilder2));
        }
    }

    private static class ComponentNode {
        private final Component component;
        private final Style style;

        ComponentNode(@NotNull Component component) {
            this(component, null);
        }

        ComponentNode(@NotNull Component component, @Nullable Style style) {
            this.component = component;
            this.style = style == null ? component.style() : component.style().merge(style, Style.Merge.Strategy.IF_ABSENT_ON_TARGET);
        }

        public Component component() {
            return this.component;
        }

        public Style style() {
            return this.style;
        }
    }
}

