/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.minimessage.Context;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.ParsingException;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.Token;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.TokenParser;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.TokenType;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.ElementNode;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.TagNode;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.ValueNode;
import ld-shaded.net.kyori.adventure.text.minimessage.template.TemplateResolver;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Modifying;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Transformation;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.TransformationRegistry;
import org.jetbrains.annotations.NotNull;

final class MiniMessageParser {
    final TransformationRegistry registry;
    final TemplateResolver templateResolver;

    MiniMessageParser() {
        this.registry = TransformationRegistry.standard();
        this.templateResolver = TemplateResolver.empty();
    }

    MiniMessageParser(TransformationRegistry transformationRegistry, TemplateResolver templateResolver) {
        this.registry = transformationRegistry;
        this.templateResolver = templateResolver;
    }

    @NotNull
    String escapeTokens(@NotNull String string, @NotNull Context context) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        this.escapeTokens(stringBuilder, string, context);
        return stringBuilder.toString();
    }

    void escapeTokens(StringBuilder stringBuilder2, @NotNull String string, @NotNull Context context) {
        this.processTokens(stringBuilder2, string, context, (token, stringBuilder) -> {
            stringBuilder.append('\\').append('<');
            if (token.type() == TokenType.CLOSE_TAG) {
                stringBuilder.append('/');
            }
            List<Token> list = token.childTokens();
            for (int i = 0; i < list.size(); ++i) {
                if (i != 0) {
                    stringBuilder.append(':');
                }
                this.escapeTokens((StringBuilder)stringBuilder, list.get(i).get(string).toString(), context);
            }
            stringBuilder.append('>');
        });
    }

    @NotNull
    String stripTokens(@NotNull String string, @NotNull Context context) {
        StringBuilder stringBuilder2 = new StringBuilder(string.length());
        this.processTokens(stringBuilder2, string, context, (token, stringBuilder) -> {});
        return stringBuilder2.toString();
    }

    private void processTokens(@NotNull StringBuilder stringBuilder, @NotNull String string, @NotNull Context context, BiConsumer<Token, StringBuilder> biConsumer) {
        TemplateResolver templateResolver = TemplateResolver.combining(context.templateResolver(), this.templateResolver);
        List<Token> list = TokenParser.tokenize(string);
        block4: for (Token token : list) {
            switch (token.type()) {
                case TEXT: {
                    stringBuilder.append(string, token.startIndex(), token.endIndex());
                    continue block4;
                }
                case OPEN_TAG: 
                case CLOSE_TAG: {
                    if (token.childTokens().isEmpty()) {
                        stringBuilder.append(string, token.startIndex(), token.endIndex());
                        continue block4;
                    }
                    String string2 = this.sanitizeTemplateName(token.childTokens().get(0).get(string).toString());
                    if (this.registry.exists(string2, templateResolver) || templateResolver.canResolve(string2)) {
                        biConsumer.accept(token, stringBuilder);
                        continue block4;
                    }
                    stringBuilder.append(string, token.startIndex(), token.endIndex());
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unsupported token type " + (Object)((Object)token.type()));
        }
    }

    @NotNull
    Component parseFormat(@NotNull String string2, @NotNull Context context) {
        TemplateResolver templateResolver = TemplateResolver.combining(context.templateResolver(), this.templateResolver);
        Appendable appendable = context.debugOutput();
        if (appendable != null) {
            try {
                appendable.append("Beginning parsing message ").append(string2).append('\n');
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Function<TagNode, Transformation> function = appendable != null ? tagNode -> {
            try {
                try {
                    appendable.append("Attempting to match node '").append(tagNode.name()).append("' at column ").append(String.valueOf(tagNode.token().startIndex())).append('\n');
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Transformation transformation = this.registry.get(this.sanitizeTemplateName(tagNode.name()), tagNode.parts(), templateResolver, context);
                try {
                    if (transformation == null) {
                        appendable.append("Could not match node '").append(tagNode.name()).append("'\n");
                    } else {
                        appendable.append("Successfully matched node '").append(tagNode.name()).append("' to transformation ").append(transformation.examinableName()).append('\n');
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return transformation;
            }
            catch (ParsingException parsingException) {
                try {
                    if (parsingException.tokens().length == 0) {
                        parsingException.tokens(new Token[]{tagNode.token()});
                    }
                    appendable.append("Could not match node '").append(tagNode.name()).append("' - ").append(parsingException.getMessage()).append('\n');
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        } : tagNode -> {
            try {
                return this.registry.get(this.sanitizeTemplateName(tagNode.name()), tagNode.parts(), templateResolver, context);
            }
            catch (ParsingException parsingException) {
                return null;
            }
        };
        BiPredicate<String, Boolean> biPredicate = (string, bl) -> {
            String string2 = this.sanitizeTemplateName((String)string);
            return this.registry.exists(string2, templateResolver) || bl != false && templateResolver.canResolve((String)string);
        };
        ElementNode elementNode = TokenParser.parse(function, biPredicate, templateResolver, string2, context.strict());
        if (appendable != null) {
            try {
                appendable.append("Text parsed into element tree:\n");
                appendable.append(elementNode.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        context.root(elementNode);
        return Objects.requireNonNull((Component)context.postProcessor().apply(this.treeToComponent(elementNode)), "Post-processor must not return null");
    }

    @NotNull
    Component treeToComponent(@NotNull ElementNode elementNode) {
        Component component;
        Transformation transformation = null;
        if (elementNode instanceof ValueNode) {
            component = Component.text(((ValueNode)elementNode).value());
        } else if (elementNode instanceof TagNode) {
            TagNode tagNode = (TagNode)elementNode;
            transformation = tagNode.transformation();
            if (transformation instanceof Modifying) {
                Modifying object = (Modifying)((Object)transformation);
                LinkedList<ElementNode> linkedList = new LinkedList<ElementNode>(elementNode.children());
                while (!linkedList.isEmpty()) {
                    ElementNode elementNode2 = linkedList.removeFirst();
                    object.visit(elementNode2);
                    linkedList.addAll(0, elementNode2.children());
                }
            }
            component = transformation.apply();
        } else {
            component = Component.empty();
        }
        for (ElementNode elementNode3 : elementNode.children()) {
            component = component.append(this.treeToComponent(elementNode3));
        }
        if (transformation instanceof Modifying) {
            component = this.handleModifying((Modifying)((Object)transformation), component, 0);
        }
        return component;
    }

    private Component handleModifying(Modifying modifying, Component component, int n) {
        Component component2 = modifying.apply(component, n);
        for (Component component3 : component.children()) {
            component2 = component2.append(this.handleModifying(modifying, component3, n + 1));
        }
        return component2;
    }

    private String sanitizeTemplateName(String string) {
        return string.toLowerCase(Locale.ROOT);
    }
}

