/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.minimessage.Context;
import ld-shaded.net.kyori.adventure.text.minimessage.MiniMessage;
import ld-shaded.net.kyori.adventure.text.minimessage.MiniMessageParser;
import ld-shaded.net.kyori.adventure.text.minimessage.MiniMessageSerializer;
import ld-shaded.net.kyori.adventure.text.minimessage.template.TemplateResolver;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.TransformationRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MiniMessageImpl
implements MiniMessage {
    static final Consumer<List<String>> DEFAULT_ERROR_CONSUMER = list -> list.forEach(System.out::println);
    static final UnaryOperator<Component> DEFAULT_COMPACTING_METHOD = Component::compact;
    static final MiniMessage INSTANCE = new MiniMessageImpl(TransformationRegistry.standard(), TemplateResolver.empty(), false, null, DEFAULT_ERROR_CONSUMER, DEFAULT_COMPACTING_METHOD);
    private final boolean strict;
    private final Appendable debugOutput;
    private final Consumer<List<String>> parsingErrorMessageConsumer;
    private final UnaryOperator<Component> postProcessor;
    final MiniMessageParser parser;

    MiniMessageImpl(@NotNull TransformationRegistry transformationRegistry, @NotNull TemplateResolver templateResolver, boolean bl, Appendable appendable, @NotNull Consumer<List<String>> consumer, @NotNull UnaryOperator<Component> unaryOperator) {
        this.parser = new MiniMessageParser(transformationRegistry, templateResolver);
        this.strict = bl;
        this.debugOutput = appendable;
        this.parsingErrorMessageConsumer = consumer;
        this.postProcessor = unaryOperator;
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull String string) {
        return this.parser.parseFormat(string, this.newContext(string, null));
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull String string, @NotNull TemplateResolver templateResolver) {
        return this.parser.parseFormat(string, this.newContext(string, Objects.requireNonNull(templateResolver, "templateResolver")));
    }

    @Override
    @NotNull
    public String serialize(@NotNull Component component) {
        return MiniMessageSerializer.serialize(component);
    }

    @Override
    @NotNull
    public String escapeTokens(@NotNull String string) {
        return this.parser.escapeTokens(string, this.newContext(string, null));
    }

    @Override
    @NotNull
    public String escapeTokens(@NotNull String string, @NotNull TemplateResolver templateResolver) {
        return this.parser.escapeTokens(string, this.newContext(string, templateResolver));
    }

    @Override
    @NotNull
    public String stripTokens(@NotNull String string) {
        return this.parser.stripTokens(string, this.newContext(string, null));
    }

    @Override
    @NotNull
    public String stripTokens(@NotNull String string, @NotNull TemplateResolver templateResolver) {
        return this.parser.stripTokens(string, this.newContext(string, templateResolver));
    }

    @NotNull
    private Context newContext(@NotNull String string, @Nullable TemplateResolver templateResolver) {
        if (templateResolver == null) {
            return Context.of(this.strict, this.debugOutput, string, this, TemplateResolver.empty(), this.postProcessor);
        }
        return Context.of(this.strict, this.debugOutput, string, this, templateResolver, this.postProcessor);
    }

    @NotNull
    public Consumer<List<String>> parsingErrorMessageConsumer() {
        return this.parsingErrorMessageConsumer;
    }

    @Override
    @NotNull
    public MiniMessage.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    implements MiniMessage.Builder {
        private TransformationRegistry registry = TransformationRegistry.standard();
        private TemplateResolver templateResolver = null;
        private boolean strict = false;
        private Appendable debug = null;
        private Consumer<List<String>> parsingErrorMessageConsumer = DEFAULT_ERROR_CONSUMER;
        private UnaryOperator<Component> postProcessor = DEFAULT_COMPACTING_METHOD;

        BuilderImpl() {
        }

        BuilderImpl(MiniMessageImpl miniMessageImpl) {
            this.registry = miniMessageImpl.parser.registry;
            this.templateResolver = miniMessageImpl.parser.templateResolver;
            this.strict = miniMessageImpl.strict;
            this.debug = miniMessageImpl.debugOutput;
            this.parsingErrorMessageConsumer = miniMessageImpl.parsingErrorMessageConsumer;
        }

        @Override
        @NotNull
        public MiniMessage.Builder transformations(@NotNull TransformationRegistry transformationRegistry) {
            this.registry = Objects.requireNonNull(transformationRegistry, "transformationRegistry");
            return this;
        }

        @Override
        @NotNull
        public MiniMessage.Builder transformations(@NotNull Consumer<TransformationRegistry.Builder> consumer) {
            TransformationRegistry.Builder builder = (TransformationRegistry.Builder)this.registry.toBuilder();
            consumer.accept(builder);
            this.registry = (TransformationRegistry)builder.build();
            return this;
        }

        @Override
        @NotNull
        public MiniMessage.Builder templateResolver(@Nullable TemplateResolver templateResolver) {
            this.templateResolver = templateResolver;
            return this;
        }

        @Override
        @NotNull
        public MiniMessage.Builder strict(boolean bl) {
            this.strict = bl;
            return this;
        }

        @Override
        @NotNull
        public MiniMessage.Builder debug(@Nullable Appendable appendable) {
            this.debug = appendable;
            return this;
        }

        @Override
        @NotNull
        public MiniMessage.Builder parsingErrorMessageConsumer(@NotNull Consumer<List<String>> consumer) {
            this.parsingErrorMessageConsumer = Objects.requireNonNull(consumer, "consumer");
            return this;
        }

        @Override
        @NotNull
        public MiniMessage.Builder postProcessor(@NotNull UnaryOperator<Component> unaryOperator) {
            this.postProcessor = Objects.requireNonNull(unaryOperator, "postProcessor");
            return this;
        }

        @Override
        @NotNull
        public MiniMessage build() {
            return new MiniMessageImpl(this.registry, this.templateResolver == null ? TemplateResolver.empty() : this.templateResolver, this.strict, this.debug, this.parsingErrorMessageConsumer, this.postProcessor);
        }
    }
}

