/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage;

import java.util.function.UnaryOperator;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.minimessage.MiniMessage;
import ld-shaded.net.kyori.adventure.text.minimessage.MiniMessageImpl;
import ld-shaded.net.kyori.adventure.text.minimessage.Template;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.ElementNode;
import ld-shaded.net.kyori.adventure.text.minimessage.template.TemplateResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Context {
    private final boolean strict;
    private final Appendable debugOutput;
    private ElementNode root;
    private final String originalMessage;
    private String replacedMessage;
    private final MiniMessage miniMessage;
    private final TemplateResolver templateResolver;
    private final UnaryOperator<Component> postProcessor;

    Context(boolean bl, Appendable appendable, ElementNode elementNode, String string, String string2, MiniMessage miniMessage, @NotNull TemplateResolver templateResolver, UnaryOperator<Component> unaryOperator) {
        this.strict = bl;
        this.debugOutput = appendable;
        this.root = elementNode;
        this.originalMessage = string;
        this.replacedMessage = string2;
        this.miniMessage = miniMessage;
        this.templateResolver = templateResolver;
        this.postProcessor = unaryOperator == null ? UnaryOperator.identity() : unaryOperator;
    }

    public static Context of(boolean bl, String string, MiniMessage miniMessage) {
        return new Context(bl, null, null, string, null, miniMessage, TemplateResolver.empty(), null);
    }

    public static Context of(boolean bl, Appendable appendable, String string, MiniMessage miniMessage) {
        return new Context(bl, appendable, null, string, null, miniMessage, TemplateResolver.empty(), null);
    }

    public static Context of(boolean bl, String string, MiniMessageImpl miniMessageImpl, @NotNull Template @Nullable [] templateArray) {
        return new Context(bl, null, null, string, null, miniMessageImpl, templateArray == null ? TemplateResolver.empty() : TemplateResolver.templates(templateArray), null);
    }

    public static Context of(boolean bl, Appendable appendable, String string, MiniMessageImpl miniMessageImpl, @NotNull Template @Nullable [] templateArray) {
        return new Context(bl, appendable, null, string, null, miniMessageImpl, templateArray == null ? TemplateResolver.empty() : TemplateResolver.templates(templateArray), null);
    }

    public static Context of(boolean bl, Appendable appendable, String string, MiniMessageImpl miniMessageImpl, TemplateResolver templateResolver) {
        return new Context(bl, appendable, null, string, null, miniMessageImpl, templateResolver, null);
    }

    public static Context of(boolean bl, Appendable appendable, String string, MiniMessageImpl miniMessageImpl, TemplateResolver templateResolver, UnaryOperator<Component> unaryOperator) {
        return new Context(bl, appendable, null, string, null, miniMessageImpl, templateResolver, unaryOperator);
    }

    public void root(ElementNode elementNode) {
        this.root = elementNode;
    }

    public void replacedMessage(String string) {
        this.replacedMessage = string;
    }

    public boolean strict() {
        return this.strict;
    }

    public Appendable debugOutput() {
        return this.debugOutput;
    }

    public ElementNode tokens() {
        return this.root;
    }

    @Deprecated
    public String ogMessage() {
        return this.originalMessage();
    }

    public String originalMessage() {
        return this.originalMessage;
    }

    public String replacedMessage() {
        return this.replacedMessage;
    }

    public MiniMessage miniMessage() {
        return this.miniMessage;
    }

    @NotNull
    public TemplateResolver templateResolver() {
        return this.templateResolver;
    }

    public UnaryOperator<Component> postProcessor() {
        return this.postProcessor;
    }

    public Component parse(String string) {
        return this.miniMessage.deserialize(string, this.templateResolver);
    }
}

