/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.format;

import ld-shaded.net.kyori.adventure.text.format.Style;
import ld-shaded.net.kyori.adventure.text.format.StyleBuilderApplicable;
import ld-shaded.net.kyori.adventure.text.format.TextDecorationAndState;
import ld-shaded.net.kyori.adventure.text.format.TextDecorationAndStateImpl;
import ld-shaded.net.kyori.adventure.text.format.TextFormat;
import ld-shaded.net.kyori.adventure.util.Index;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum TextDecoration implements StyleBuilderApplicable,
TextFormat
{
    OBFUSCATED("obfuscated"),
    BOLD("bold"),
    STRIKETHROUGH("strikethrough"),
    UNDERLINED("underlined"),
    ITALIC("italic");

    public static final Index<String, TextDecoration> NAMES;
    private final String name;

    private TextDecoration(String string2) {
        this.name = string2;
    }

    @NotNull
    public final TextDecorationAndState as(boolean bl) {
        return this.as(State.byBoolean(bl));
    }

    @NotNull
    public final TextDecorationAndState as(@NotNull State state) {
        return new TextDecorationAndStateImpl(this, state);
    }

    @Override
    public void styleApply(@NotNull Style.Builder builder) {
        builder.decorate(this);
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    static {
        NAMES = Index.create(TextDecoration.class, textDecoration -> textDecoration.name);
    }

    public static enum State {
        NOT_SET("not_set"),
        FALSE("false"),
        TRUE("true");

        private final String name;

        private State(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public static State byBoolean(boolean bl) {
            return bl ? TRUE : FALSE;
        }

        @NotNull
        public static State byBoolean(@Nullable Boolean bl) {
            return bl == null ? NOT_SET : State.byBoolean((boolean)bl);
        }
    }
}

