/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.format;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import ld-shaded.net.kyori.adventure.key.Key;
import ld-shaded.net.kyori.adventure.text.event.ClickEvent;
import ld-shaded.net.kyori.adventure.text.event.HoverEvent;
import ld-shaded.net.kyori.adventure.text.event.HoverEventSource;
import ld-shaded.net.kyori.adventure.text.format.AlwaysMerger;
import ld-shaded.net.kyori.adventure.text.format.IfAbsentOnTargetMerger;
import ld-shaded.net.kyori.adventure.text.format.Merger;
import ld-shaded.net.kyori.adventure.text.format.Style;
import ld-shaded.net.kyori.adventure.text.format.TextColor;
import ld-shaded.net.kyori.adventure.text.format.TextDecoration;
import ld-shaded.net.kyori.examination.ExaminableProperty;
import ld-shaded.net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StyleImpl
implements Style {
    static final StyleImpl EMPTY = new StyleImpl(null, null, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, null, null, null);
    private static final TextDecoration[] DECORATIONS = TextDecoration.values();
    @Nullable
    final Key font;
    @Nullable
    final TextColor color;
    final TextDecoration.State obfuscated;
    final TextDecoration.State bold;
    final TextDecoration.State strikethrough;
    final TextDecoration.State underlined;
    final TextDecoration.State italic;
    @Nullable
    final ClickEvent clickEvent;
    @Nullable
    final HoverEvent<?> hoverEvent;
    @Nullable
    final String insertion;

    static void decorate(Style.Builder builder, TextDecoration[] textDecorationArray) {
        for (TextDecoration textDecoration : textDecorationArray) {
            builder.decoration(textDecoration, true);
        }
    }

    StyleImpl(@Nullable Key key, @Nullable TextColor textColor, TextDecoration.State state, TextDecoration.State state2, TextDecoration.State state3, TextDecoration.State state4, TextDecoration.State state5, @Nullable ClickEvent clickEvent, @Nullable HoverEvent<?> hoverEvent, @Nullable String string) {
        this.font = key;
        this.color = textColor;
        this.obfuscated = state;
        this.bold = state2;
        this.strikethrough = state3;
        this.underlined = state4;
        this.italic = state5;
        this.clickEvent = clickEvent;
        this.hoverEvent = hoverEvent;
        this.insertion = string;
    }

    @Override
    @Nullable
    public Key font() {
        return this.font;
    }

    @Override
    @NotNull
    public Style font(@Nullable Key key) {
        if (Objects.equals(this.font, key)) {
            return this;
        }
        return new StyleImpl(key, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion);
    }

    @Override
    @Nullable
    public TextColor color() {
        return this.color;
    }

    @Override
    @NotNull
    public Style color(@Nullable TextColor textColor) {
        if (Objects.equals(this.color, textColor)) {
            return this;
        }
        return new StyleImpl(this.font, textColor, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion);
    }

    @Override
    @NotNull
    public Style colorIfAbsent(@Nullable TextColor textColor) {
        if (this.color == null) {
            return this.color(textColor);
        }
        return this;
    }

    @Override
    public @NotNull TextDecoration.State decoration(@NotNull TextDecoration textDecoration) {
        if (textDecoration == TextDecoration.BOLD) {
            return this.bold;
        }
        if (textDecoration == TextDecoration.ITALIC) {
            return this.italic;
        }
        if (textDecoration == TextDecoration.UNDERLINED) {
            return this.underlined;
        }
        if (textDecoration == TextDecoration.STRIKETHROUGH) {
            return this.strikethrough;
        }
        if (textDecoration == TextDecoration.OBFUSCATED) {
            return this.obfuscated;
        }
        throw new IllegalArgumentException(String.format("unknown decoration '%s'", textDecoration));
    }

    @Override
    @NotNull
    public Style decoration(@NotNull TextDecoration textDecoration, @NotNull TextDecoration.State state) {
        Objects.requireNonNull(state, "state");
        if (textDecoration == TextDecoration.BOLD) {
            return new StyleImpl(this.font, this.color, this.obfuscated, state, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion);
        }
        if (textDecoration == TextDecoration.ITALIC) {
            return new StyleImpl(this.font, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, state, this.clickEvent, this.hoverEvent, this.insertion);
        }
        if (textDecoration == TextDecoration.UNDERLINED) {
            return new StyleImpl(this.font, this.color, this.obfuscated, this.bold, this.strikethrough, state, this.italic, this.clickEvent, this.hoverEvent, this.insertion);
        }
        if (textDecoration == TextDecoration.STRIKETHROUGH) {
            return new StyleImpl(this.font, this.color, this.obfuscated, this.bold, state, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion);
        }
        if (textDecoration == TextDecoration.OBFUSCATED) {
            return new StyleImpl(this.font, this.color, state, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion);
        }
        throw new IllegalArgumentException(String.format("unknown decoration '%s'", textDecoration));
    }

    @Override
    @NotNull
    public Map<TextDecoration, TextDecoration.State> decorations() {
        EnumMap<TextDecoration, TextDecoration.State> enumMap = new EnumMap<TextDecoration, TextDecoration.State>(TextDecoration.class);
        for (TextDecoration textDecoration : DECORATIONS) {
            TextDecoration.State state = this.decoration(textDecoration);
            enumMap.put(textDecoration, state);
        }
        return enumMap;
    }

    @Override
    @NotNull
    public Style decorations(@NotNull Map<TextDecoration, TextDecoration.State> map) {
        TextDecoration.State state = map.getOrDefault(TextDecoration.OBFUSCATED, this.obfuscated);
        TextDecoration.State state2 = map.getOrDefault(TextDecoration.BOLD, this.bold);
        TextDecoration.State state3 = map.getOrDefault(TextDecoration.STRIKETHROUGH, this.strikethrough);
        TextDecoration.State state4 = map.getOrDefault(TextDecoration.UNDERLINED, this.underlined);
        TextDecoration.State state5 = map.getOrDefault(TextDecoration.ITALIC, this.italic);
        return new StyleImpl(this.font, this.color, state, state2, state3, state4, state5, this.clickEvent, this.hoverEvent, this.insertion);
    }

    @Override
    @Nullable
    public ClickEvent clickEvent() {
        return this.clickEvent;
    }

    @Override
    @NotNull
    public Style clickEvent(@Nullable ClickEvent clickEvent) {
        return new StyleImpl(this.font, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, clickEvent, this.hoverEvent, this.insertion);
    }

    @Override
    @Nullable
    public HoverEvent<?> hoverEvent() {
        return this.hoverEvent;
    }

    @Override
    @NotNull
    public Style hoverEvent(@Nullable HoverEventSource<?> hoverEventSource) {
        return new StyleImpl(this.font, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, HoverEventSource.unbox(hoverEventSource), this.insertion);
    }

    @Override
    @Nullable
    public String insertion() {
        return this.insertion;
    }

    @Override
    @NotNull
    public Style insertion(@Nullable String string) {
        if (Objects.equals(this.insertion, string)) {
            return this;
        }
        return new StyleImpl(this.font, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, string);
    }

    @Override
    @NotNull
    public Style merge(@NotNull Style style, @NotNull Style.Merge.Strategy strategy, @NotNull Set<Style.Merge> set) {
        if (style.isEmpty() || strategy == Style.Merge.Strategy.NEVER || set.isEmpty()) {
            return this;
        }
        if (this.isEmpty() && Style.Merge.hasAll(set)) {
            return style;
        }
        Style.Builder builder = this.toBuilder();
        builder.merge(style, strategy, set);
        return builder.build();
    }

    @Override
    public boolean isEmpty() {
        return this == EMPTY;
    }

    @Override
    @NotNull
    public Style.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("color", this.color), ExaminableProperty.of("obfuscated", (Object)this.obfuscated), ExaminableProperty.of("bold", (Object)this.bold), ExaminableProperty.of("strikethrough", (Object)this.strikethrough), ExaminableProperty.of("underlined", (Object)this.underlined), ExaminableProperty.of("italic", (Object)this.italic), ExaminableProperty.of("clickEvent", this.clickEvent), ExaminableProperty.of("hoverEvent", this.hoverEvent), ExaminableProperty.of("insertion", this.insertion), ExaminableProperty.of("font", this.font));
    }

    @NotNull
    public String toString() {
        return this.examine(StringExaminer.simpleEscaping());
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StyleImpl)) {
            return false;
        }
        StyleImpl styleImpl = (StyleImpl)object;
        return Objects.equals(this.color, styleImpl.color) && this.obfuscated == styleImpl.obfuscated && this.bold == styleImpl.bold && this.strikethrough == styleImpl.strikethrough && this.underlined == styleImpl.underlined && this.italic == styleImpl.italic && Objects.equals(this.clickEvent, styleImpl.clickEvent) && Objects.equals(this.hoverEvent, styleImpl.hoverEvent) && Objects.equals(this.insertion, styleImpl.insertion) && Objects.equals(this.font, styleImpl.font);
    }

    public int hashCode() {
        int n = Objects.hashCode(this.color);
        n = 31 * n + this.obfuscated.hashCode();
        n = 31 * n + this.bold.hashCode();
        n = 31 * n + this.strikethrough.hashCode();
        n = 31 * n + this.underlined.hashCode();
        n = 31 * n + this.italic.hashCode();
        n = 31 * n + Objects.hashCode(this.clickEvent);
        n = 31 * n + Objects.hashCode(this.hoverEvent);
        n = 31 * n + Objects.hashCode(this.insertion);
        n = 31 * n + Objects.hashCode(this.font);
        return n;
    }

    static final class BuilderImpl
    implements Style.Builder {
        @Nullable
        Key font;
        @Nullable
        TextColor color;
        TextDecoration.State obfuscated = TextDecoration.State.NOT_SET;
        TextDecoration.State bold = TextDecoration.State.NOT_SET;
        TextDecoration.State strikethrough = TextDecoration.State.NOT_SET;
        TextDecoration.State underlined = TextDecoration.State.NOT_SET;
        TextDecoration.State italic = TextDecoration.State.NOT_SET;
        @Nullable
        ClickEvent clickEvent;
        @Nullable
        HoverEvent<?> hoverEvent;
        @Nullable
        String insertion;

        BuilderImpl() {
        }

        BuilderImpl(@NotNull StyleImpl styleImpl) {
            this.color = styleImpl.color;
            this.obfuscated = styleImpl.obfuscated;
            this.bold = styleImpl.bold;
            this.strikethrough = styleImpl.strikethrough;
            this.underlined = styleImpl.underlined;
            this.italic = styleImpl.italic;
            this.clickEvent = styleImpl.clickEvent;
            this.hoverEvent = styleImpl.hoverEvent;
            this.insertion = styleImpl.insertion;
            this.font = styleImpl.font;
        }

        @Override
        @NotNull
        public Style.Builder font(@Nullable Key key) {
            this.font = key;
            return this;
        }

        @Override
        @NotNull
        public Style.Builder color(@Nullable TextColor textColor) {
            this.color = textColor;
            return this;
        }

        @Override
        @NotNull
        public Style.Builder colorIfAbsent(@Nullable TextColor textColor) {
            if (this.color == null) {
                this.color = textColor;
            }
            return this;
        }

        @Override
        @NotNull
        public Style.Builder decorate(@NotNull TextDecoration textDecoration) {
            return this.decoration(textDecoration, TextDecoration.State.TRUE);
        }

        @Override
        @NotNull
        public Style.Builder decorate(TextDecoration ... textDecorationArray) {
            int n = textDecorationArray.length;
            for (int i = 0; i < n; ++i) {
                this.decorate(textDecorationArray[i]);
            }
            return this;
        }

        @Override
        @NotNull
        public Style.Builder decoration(@NotNull TextDecoration textDecoration, @NotNull TextDecoration.State state) {
            Objects.requireNonNull(state, "state");
            if (textDecoration == TextDecoration.BOLD) {
                this.bold = state;
                return this;
            }
            if (textDecoration == TextDecoration.ITALIC) {
                this.italic = state;
                return this;
            }
            if (textDecoration == TextDecoration.UNDERLINED) {
                this.underlined = state;
                return this;
            }
            if (textDecoration == TextDecoration.STRIKETHROUGH) {
                this.strikethrough = state;
                return this;
            }
            if (textDecoration == TextDecoration.OBFUSCATED) {
                this.obfuscated = state;
                return this;
            }
            throw new IllegalArgumentException(String.format("unknown decoration '%s'", textDecoration));
        }

        @NotNull
        Style.Builder decorationIfAbsent(@NotNull TextDecoration textDecoration, @NotNull TextDecoration.State state) {
            Objects.requireNonNull(state, "state");
            if (textDecoration == TextDecoration.BOLD) {
                if (this.bold == TextDecoration.State.NOT_SET) {
                    this.bold = state;
                }
                return this;
            }
            if (textDecoration == TextDecoration.ITALIC) {
                if (this.italic == TextDecoration.State.NOT_SET) {
                    this.italic = state;
                }
                return this;
            }
            if (textDecoration == TextDecoration.UNDERLINED) {
                if (this.underlined == TextDecoration.State.NOT_SET) {
                    this.underlined = state;
                }
                return this;
            }
            if (textDecoration == TextDecoration.STRIKETHROUGH) {
                if (this.strikethrough == TextDecoration.State.NOT_SET) {
                    this.strikethrough = state;
                }
                return this;
            }
            if (textDecoration == TextDecoration.OBFUSCATED) {
                if (this.obfuscated == TextDecoration.State.NOT_SET) {
                    this.obfuscated = state;
                }
                return this;
            }
            throw new IllegalArgumentException(String.format("unknown decoration '%s'", textDecoration));
        }

        @Override
        @NotNull
        public Style.Builder clickEvent(@Nullable ClickEvent clickEvent) {
            this.clickEvent = clickEvent;
            return this;
        }

        @Override
        @NotNull
        public Style.Builder hoverEvent(@Nullable HoverEventSource<?> hoverEventSource) {
            this.hoverEvent = HoverEventSource.unbox(hoverEventSource);
            return this;
        }

        @Override
        @NotNull
        public Style.Builder insertion(@Nullable String string) {
            this.insertion = string;
            return this;
        }

        @Override
        @NotNull
        public Style.Builder merge(@NotNull Style style, @NotNull Style.Merge.Strategy strategy, @NotNull Set<Style.Merge> set) {
            Object object;
            if (strategy == Style.Merge.Strategy.NEVER || style.isEmpty() || set.isEmpty()) {
                return this;
            }
            Merger merger = BuilderImpl.merger(strategy);
            if (set.contains((Object)Style.Merge.COLOR) && (object = style.color()) != null) {
                merger.mergeColor(this, (TextColor)object);
            }
            if (set.contains((Object)Style.Merge.DECORATIONS)) {
                int n = DECORATIONS.length;
                for (int i = 0; i < n; ++i) {
                    TextDecoration textDecoration = DECORATIONS[i];
                    TextDecoration.State state = style.decoration(textDecoration);
                    if (state == TextDecoration.State.NOT_SET) continue;
                    merger.mergeDecoration(this, textDecoration, state);
                }
            }
            if (set.contains((Object)Style.Merge.EVENTS)) {
                HoverEvent<?> hoverEvent;
                object = style.clickEvent();
                if (object != null) {
                    merger.mergeClickEvent(this, (ClickEvent)object);
                }
                if ((hoverEvent = style.hoverEvent()) != null) {
                    merger.mergeHoverEvent(this, hoverEvent);
                }
            }
            if (set.contains((Object)Style.Merge.INSERTION) && (object = style.insertion()) != null) {
                merger.mergeInsertion(this, (String)object);
            }
            if (set.contains((Object)Style.Merge.FONT) && (object = style.font()) != null) {
                merger.mergeFont(this, (Key)object);
            }
            return this;
        }

        private static Merger merger(Style.Merge.Strategy strategy) {
            if (strategy == Style.Merge.Strategy.ALWAYS) {
                return AlwaysMerger.INSTANCE;
            }
            if (strategy == Style.Merge.Strategy.NEVER) {
                throw new UnsupportedOperationException();
            }
            if (strategy == Style.Merge.Strategy.IF_ABSENT_ON_TARGET) {
                return IfAbsentOnTargetMerger.INSTANCE;
            }
            throw new IllegalArgumentException(strategy.name());
        }

        @Override
        @NotNull
        public StyleImpl build() {
            if (this.isEmpty()) {
                return EMPTY;
            }
            return new StyleImpl(this.font, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion);
        }

        private boolean isEmpty() {
            return this.color == null && this.obfuscated == TextDecoration.State.NOT_SET && this.bold == TextDecoration.State.NOT_SET && this.strikethrough == TextDecoration.State.NOT_SET && this.underlined == TextDecoration.State.NOT_SET && this.italic == TextDecoration.State.NOT_SET && this.clickEvent == null && this.hoverEvent == null && this.insertion == null && this.font == null;
        }
    }
}

