/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import ld-shaded.net.kyori.adventure.text.AbstractComponent;
import ld-shaded.net.kyori.adventure.text.AbstractComponentBuilder;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.ComponentLike;
import ld-shaded.net.kyori.adventure.text.LegacyFormattingDetected;
import ld-shaded.net.kyori.adventure.text.TextComponent;
import ld-shaded.net.kyori.adventure.text.format.Style;
import ld-shaded.net.kyori.adventure.util.Nag;
import ld-shaded.net.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

final class TextComponentImpl
extends AbstractComponent
implements TextComponent {
    private static final boolean WARN_WHEN_LEGACY_FORMATTING_DETECTED = Boolean.getBoolean(String.join((CharSequence)".", "net", "kyori", "adventure", "text", "warnWhenLegacyFormattingDetected"));
    @VisibleForTesting
    static final char SECTION_CHAR = '\u00a7';
    static final TextComponent EMPTY = TextComponentImpl.createDirect("");
    static final TextComponent NEWLINE = TextComponentImpl.createDirect("\n");
    static final TextComponent SPACE = TextComponentImpl.createDirect(" ");
    private final String content;

    @NotNull
    private static TextComponent createDirect(@NotNull String string) {
        return new TextComponentImpl(Collections.emptyList(), Style.empty(), string);
    }

    TextComponentImpl(@NotNull List<? extends ComponentLike> list, @NotNull Style style, @NotNull String string) {
        super(list, style);
        LegacyFormattingDetected legacyFormattingDetected;
        this.content = Objects.requireNonNull(string, "content");
        if (WARN_WHEN_LEGACY_FORMATTING_DETECTED && (legacyFormattingDetected = this.warnWhenLegacyFormattingDetected()) != null) {
            Nag.print(legacyFormattingDetected);
        }
    }

    @VisibleForTesting
    @Nullable
    final LegacyFormattingDetected warnWhenLegacyFormattingDetected() {
        if (this.content.indexOf(167) != -1) {
            return new LegacyFormattingDetected(this);
        }
        return null;
    }

    @Override
    @NotNull
    public String content() {
        return this.content;
    }

    @Override
    @NotNull
    public TextComponent content(@NotNull String string) {
        if (Objects.equals(this.content, string)) {
            return this;
        }
        return new TextComponentImpl(this.children, this.style, Objects.requireNonNull(string, "content"));
    }

    @Override
    @NotNull
    public TextComponent children(@NotNull List<? extends ComponentLike> list) {
        return new TextComponentImpl(list, this.style, this.content);
    }

    @Override
    @NotNull
    public TextComponent style(@NotNull Style style) {
        return new TextComponentImpl(this.children, style, this.content);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TextComponentImpl)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        TextComponentImpl textComponentImpl = (TextComponentImpl)object;
        return Objects.equals(this.content, textComponentImpl.content);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.content.hashCode();
        return n;
    }

    @Override
    @NotNull
    protected Stream<? extends ExaminableProperty> examinablePropertiesWithoutChildren() {
        return Stream.concat(Stream.of(ExaminableProperty.of("content", this.content)), super.examinablePropertiesWithoutChildren());
    }

    @Override
    @NotNull
    public TextComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    extends AbstractComponentBuilder<TextComponent, TextComponent.Builder>
    implements TextComponent.Builder {
        private String content = "";

        BuilderImpl() {
        }

        BuilderImpl(@NotNull TextComponent textComponent) {
            super(textComponent);
            this.content = textComponent.content();
        }

        @Override
        @NotNull
        public TextComponent.Builder content(@NotNull String string) {
            this.content = Objects.requireNonNull(string, "content");
            return this;
        }

        @Override
        @NotNull
        public String content() {
            return this.content;
        }

        @Override
        @NotNull
        public TextComponent build() {
            if (this.isEmpty()) {
                return Component.empty();
            }
            return new TextComponentImpl(this.children, this.buildStyle(), this.content);
        }

        private boolean isEmpty() {
            return this.content.isEmpty() && this.children.isEmpty() && !this.hasStyle();
        }
    }
}

