/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import ld-shaded.net.kyori.adventure.key.Key;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.ComponentLike;
import ld-shaded.net.kyori.adventure.text.NBTComponentImpl;
import ld-shaded.net.kyori.adventure.text.StorageNBTComponent;
import ld-shaded.net.kyori.adventure.text.format.Style;
import ld-shaded.net.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StorageNBTComponentImpl
extends NBTComponentImpl<StorageNBTComponent, StorageNBTComponent.Builder>
implements StorageNBTComponent {
    private final Key storage;

    StorageNBTComponentImpl(@NotNull List<? extends ComponentLike> list, @NotNull Style style, String string, boolean bl, @Nullable ComponentLike componentLike, Key key) {
        super(list, style, string, bl, componentLike);
        this.storage = key;
    }

    @Override
    @NotNull
    public StorageNBTComponent nbtPath(@NotNull String string) {
        if (Objects.equals(this.nbtPath, string)) {
            return this;
        }
        return new StorageNBTComponentImpl(this.children, this.style, string, this.interpret, this.separator, this.storage);
    }

    @Override
    @NotNull
    public StorageNBTComponent interpret(boolean bl) {
        if (this.interpret == bl) {
            return this;
        }
        return new StorageNBTComponentImpl(this.children, this.style, this.nbtPath, bl, this.separator, this.storage);
    }

    @Override
    @Nullable
    public Component separator() {
        return this.separator;
    }

    @Override
    @NotNull
    public StorageNBTComponent separator(@Nullable ComponentLike componentLike) {
        return new StorageNBTComponentImpl(this.children, this.style, this.nbtPath, this.interpret, componentLike, this.storage);
    }

    @Override
    @NotNull
    public Key storage() {
        return this.storage;
    }

    @Override
    @NotNull
    public StorageNBTComponent storage(@NotNull Key key) {
        if (Objects.equals(this.storage, key)) {
            return this;
        }
        return new StorageNBTComponentImpl(this.children, this.style, this.nbtPath, this.interpret, this.separator, key);
    }

    @Override
    @NotNull
    public StorageNBTComponent children(@NotNull List<? extends ComponentLike> list) {
        return new StorageNBTComponentImpl(list, this.style, this.nbtPath, this.interpret, this.separator, this.storage);
    }

    @Override
    @NotNull
    public StorageNBTComponent style(@NotNull Style style) {
        return new StorageNBTComponentImpl(this.children, style, this.nbtPath, this.interpret, this.separator, this.storage);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StorageNBTComponent)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        StorageNBTComponentImpl storageNBTComponentImpl = (StorageNBTComponentImpl)object;
        return Objects.equals(this.storage, storageNBTComponentImpl.storage());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.storage.hashCode();
        return n;
    }

    @Override
    @NotNull
    protected Stream<? extends ExaminableProperty> examinablePropertiesWithoutChildren() {
        return Stream.concat(Stream.of(ExaminableProperty.of("storage", this.storage)), super.examinablePropertiesWithoutChildren());
    }

    @Override
    public @NotNull StorageNBTComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static class BuilderImpl
    extends NBTComponentImpl.BuilderImpl<StorageNBTComponent, StorageNBTComponent.Builder>
    implements StorageNBTComponent.Builder {
        @Nullable
        private Key storage;

        BuilderImpl() {
        }

        BuilderImpl(@NotNull StorageNBTComponent storageNBTComponent) {
            super(storageNBTComponent);
            this.storage = storageNBTComponent.storage();
        }

        @Override
        public @NotNull StorageNBTComponent.Builder storage(@NotNull Key key) {
            this.storage = key;
            return this;
        }

        @Override
        @NotNull
        public StorageNBTComponent build() {
            if (this.nbtPath == null) {
                throw new IllegalStateException("nbt path must be set");
            }
            if (this.storage == null) {
                throw new IllegalStateException("storage must be set");
            }
            return new StorageNBTComponentImpl(this.children, this.buildStyle(), this.nbtPath, this.interpret, this.separator, this.storage);
        }
    }
}

