/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import ld-shaded.net.kyori.adventure.text.AbstractComponent;
import ld-shaded.net.kyori.adventure.text.AbstractComponentBuilder;
import ld-shaded.net.kyori.adventure.text.ComponentLike;
import ld-shaded.net.kyori.adventure.text.ScoreComponent;
import ld-shaded.net.kyori.adventure.text.format.Style;
import ld-shaded.net.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ScoreComponentImpl
extends AbstractComponent
implements ScoreComponent {
    private final String name;
    private final String objective;
    @Deprecated
    @Nullable
    private final String value;

    ScoreComponentImpl(@NotNull List<? extends ComponentLike> list, @NotNull Style style, @NotNull String string, @NotNull String string2, @Nullable String string3) {
        super(list, style);
        this.name = string;
        this.objective = string2;
        this.value = string3;
    }

    @Override
    @NotNull
    public String name() {
        return this.name;
    }

    @Override
    @NotNull
    public ScoreComponent name(@NotNull String string) {
        if (Objects.equals(this.name, string)) {
            return this;
        }
        return new ScoreComponentImpl(this.children, this.style, Objects.requireNonNull(string, "name"), this.objective, this.value);
    }

    @Override
    @NotNull
    public String objective() {
        return this.objective;
    }

    @Override
    @NotNull
    public ScoreComponent objective(@NotNull String string) {
        if (Objects.equals(this.objective, string)) {
            return this;
        }
        return new ScoreComponentImpl(this.children, this.style, this.name, Objects.requireNonNull(string, "objective"), this.value);
    }

    @Override
    @Deprecated
    @Nullable
    public String value() {
        return this.value;
    }

    @Override
    @Deprecated
    @NotNull
    public ScoreComponent value(@Nullable String string) {
        if (Objects.equals(this.value, string)) {
            return this;
        }
        return new ScoreComponentImpl(this.children, this.style, this.name, this.objective, string);
    }

    @Override
    @NotNull
    public ScoreComponent children(@NotNull List<? extends ComponentLike> list) {
        return new ScoreComponentImpl(list, this.style, this.name, this.objective, this.value);
    }

    @Override
    @NotNull
    public ScoreComponent style(@NotNull Style style) {
        return new ScoreComponentImpl(this.children, style, this.name, this.objective, this.value);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ScoreComponent)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ScoreComponent scoreComponent = (ScoreComponent)object;
        return Objects.equals(this.name, scoreComponent.name()) && Objects.equals(this.objective, scoreComponent.objective()) && Objects.equals(this.value, scoreComponent.value());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.name.hashCode();
        n = 31 * n + this.objective.hashCode();
        n = 31 * n + Objects.hashCode(this.value);
        return n;
    }

    @Override
    @NotNull
    protected Stream<? extends ExaminableProperty> examinablePropertiesWithoutChildren() {
        return Stream.concat(Stream.of(ExaminableProperty.of("name", this.name), ExaminableProperty.of("objective", this.objective), ExaminableProperty.of("value", this.value)), super.examinablePropertiesWithoutChildren());
    }

    @Override
    @NotNull
    public ScoreComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    extends AbstractComponentBuilder<ScoreComponent, ScoreComponent.Builder>
    implements ScoreComponent.Builder {
        @Nullable
        private String name;
        @Nullable
        private String objective;
        @Nullable
        private String value;

        BuilderImpl() {
        }

        BuilderImpl(@NotNull ScoreComponent scoreComponent) {
            super(scoreComponent);
            this.name = scoreComponent.name();
            this.objective = scoreComponent.objective();
            this.value = scoreComponent.value();
        }

        @Override
        @NotNull
        public ScoreComponent.Builder name(@NotNull String string) {
            this.name = string;
            return this;
        }

        @Override
        @NotNull
        public ScoreComponent.Builder objective(@NotNull String string) {
            this.objective = string;
            return this;
        }

        @Override
        @Deprecated
        @NotNull
        public ScoreComponent.Builder value(@Nullable String string) {
            this.value = string;
            return this;
        }

        @Override
        @NotNull
        public ScoreComponent build() {
            if (this.name == null) {
                throw new IllegalStateException("name must be set");
            }
            if (this.objective == null) {
                throw new IllegalStateException("objective must be set");
            }
            return new ScoreComponentImpl(this.children, this.buildStyle(), this.name, this.objective, this.value);
        }
    }
}

