/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import ld-shaded.net.kyori.adventure.text.AbstractComponent;
import ld-shaded.net.kyori.adventure.text.AbstractComponentBuilder;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.ComponentLike;
import ld-shaded.net.kyori.adventure.text.NBTComponent;
import ld-shaded.net.kyori.adventure.text.NBTComponentBuilder;
import ld-shaded.net.kyori.adventure.text.format.Style;
import ld-shaded.net.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class NBTComponentImpl<C extends NBTComponent<C, B>, B extends NBTComponentBuilder<C, B>>
extends AbstractComponent
implements NBTComponent<C, B> {
    static final boolean INTERPRET_DEFAULT = false;
    final String nbtPath;
    final boolean interpret;
    @Nullable
    final Component separator;

    NBTComponentImpl(@NotNull List<? extends ComponentLike> list, @NotNull Style style, String string, boolean bl, @Nullable ComponentLike componentLike) {
        super(list, style);
        this.nbtPath = string;
        this.interpret = bl;
        this.separator = ComponentLike.unbox(componentLike);
    }

    @Override
    @NotNull
    public String nbtPath() {
        return this.nbtPath;
    }

    @Override
    public boolean interpret() {
        return this.interpret;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NBTComponent)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        NBTComponent nBTComponent = (NBTComponent)object;
        return Objects.equals(this.nbtPath, nBTComponent.nbtPath()) && this.interpret == nBTComponent.interpret() && Objects.equals(this.separator, nBTComponent.separator());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.nbtPath.hashCode();
        n = 31 * n + Boolean.hashCode(this.interpret);
        n = 31 * n + Objects.hashCode(this.separator);
        return n;
    }

    @Override
    @NotNull
    protected Stream<? extends ExaminableProperty> examinablePropertiesWithoutChildren() {
        return Stream.concat(Stream.of(ExaminableProperty.of("nbtPath", this.nbtPath), ExaminableProperty.of("interpret", this.interpret), ExaminableProperty.of("separator", this.separator)), super.examinablePropertiesWithoutChildren());
    }

    static abstract class BuilderImpl<C extends NBTComponent<C, B>, B extends NBTComponentBuilder<C, B>>
    extends AbstractComponentBuilder<C, B>
    implements NBTComponentBuilder<C, B> {
        @Nullable
        protected String nbtPath;
        protected boolean interpret = false;
        @Nullable
        protected Component separator;

        BuilderImpl() {
        }

        BuilderImpl(@NotNull C c) {
            super(c);
            this.nbtPath = c.nbtPath();
            this.interpret = c.interpret();
        }

        @Override
        @NotNull
        public B nbtPath(@NotNull String string) {
            this.nbtPath = string;
            return (B)this;
        }

        @Override
        @NotNull
        public B interpret(boolean bl) {
            this.interpret = bl;
            return (B)this;
        }

        @Override
        @NotNull
        public B separator(@Nullable ComponentLike componentLike) {
            this.separator = ComponentLike.unbox(componentLike);
            return (B)this;
        }
    }
}

