/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.ComponentLike;
import ld-shaded.net.kyori.adventure.text.JoinConfiguration;
import ld-shaded.net.kyori.adventure.text.TextComponent;
import ld-shaded.net.kyori.examination.ExaminableProperty;
import ld-shaded.net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JoinConfigurationImpl
implements JoinConfiguration {
    static final Function<ComponentLike, Component> DEFAULT_CONVERTOR = ComponentLike::asComponent;
    static final Predicate<ComponentLike> DEFAULT_PREDICATE = componentLike -> true;
    static final JoinConfigurationImpl NULL = new JoinConfigurationImpl();
    private final Component prefix;
    private final Component suffix;
    private final Component separator;
    private final Component lastSeparator;
    private final Component lastSeparatorIfSerial;
    private final Function<ComponentLike, Component> convertor;
    private final Predicate<ComponentLike> predicate;

    private JoinConfigurationImpl() {
        this.prefix = null;
        this.suffix = null;
        this.separator = null;
        this.lastSeparator = null;
        this.lastSeparatorIfSerial = null;
        this.convertor = DEFAULT_CONVERTOR;
        this.predicate = DEFAULT_PREDICATE;
    }

    private JoinConfigurationImpl(@NotNull BuilderImpl builderImpl) {
        this.prefix = builderImpl.prefix == null ? null : builderImpl.prefix.asComponent();
        this.suffix = builderImpl.suffix == null ? null : builderImpl.suffix.asComponent();
        this.separator = builderImpl.separator == null ? null : builderImpl.separator.asComponent();
        this.lastSeparator = builderImpl.lastSeparator == null ? null : builderImpl.lastSeparator.asComponent();
        this.lastSeparatorIfSerial = builderImpl.lastSeparatorIfSerial == null ? null : builderImpl.lastSeparatorIfSerial.asComponent();
        this.convertor = builderImpl.convertor;
        this.predicate = builderImpl.predicate;
    }

    @Override
    @Nullable
    public Component prefix() {
        return this.prefix;
    }

    @Override
    @Nullable
    public Component suffix() {
        return this.suffix;
    }

    @Override
    @Nullable
    public Component separator() {
        return this.separator;
    }

    @Override
    @Nullable
    public Component lastSeparator() {
        return this.lastSeparator;
    }

    @Override
    @Nullable
    public Component lastSeparatorIfSerial() {
        return this.lastSeparatorIfSerial;
    }

    @Override
    @NotNull
    public Function<ComponentLike, Component> convertor() {
        return this.convertor;
    }

    @Override
    @NotNull
    public Predicate<ComponentLike> predicate() {
        return this.predicate;
    }

    @Override
    public @NotNull JoinConfiguration.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("prefix", this.prefix), ExaminableProperty.of("suffix", this.suffix), ExaminableProperty.of("separator", this.separator), ExaminableProperty.of("lastSeparator", this.lastSeparator), ExaminableProperty.of("lastSeparatorIfSerial", this.lastSeparatorIfSerial), ExaminableProperty.of("convertor", this.convertor), ExaminableProperty.of("predicate", this.predicate));
    }

    public String toString() {
        return this.examine(StringExaminer.simpleEscaping());
    }

    @Contract(pure=true)
    @NotNull
    static Component join(@NotNull JoinConfiguration joinConfiguration, @NotNull Iterable<? extends ComponentLike> iterable) {
        Objects.requireNonNull(joinConfiguration, "config");
        Objects.requireNonNull(iterable, "components");
        Iterator<? extends ComponentLike> iterator = iterable.iterator();
        Component component = joinConfiguration.prefix();
        Component component2 = joinConfiguration.suffix();
        Function<ComponentLike, Component> function = joinConfiguration.convertor();
        Predicate<ComponentLike> predicate = joinConfiguration.predicate();
        if (!iterator.hasNext()) {
            return JoinConfigurationImpl.singleElementJoin(joinConfiguration, null);
        }
        ComponentLike componentLike = Objects.requireNonNull(iterator.next(), "Null elements in \"components\" are not allowed");
        int n = 0;
        if (!iterator.hasNext()) {
            return JoinConfigurationImpl.singleElementJoin(joinConfiguration, componentLike);
        }
        Component component3 = joinConfiguration.separator();
        boolean bl = component3 != null;
        TextComponent.Builder builder = Component.text();
        if (component != null) {
            builder.append(component);
        }
        while (componentLike != null) {
            if (!predicate.test(componentLike)) {
                if (!iterator.hasNext()) break;
                componentLike = iterator.next();
                continue;
            }
            builder.append(Objects.requireNonNull(function.apply(componentLike), "Null output from \"convertor\" is not allowed"));
            ++n;
            if (!iterator.hasNext()) {
                componentLike = null;
                continue;
            }
            componentLike = Objects.requireNonNull(iterator.next(), "Null elements in \"components\" are not allowed");
            if (iterator.hasNext()) {
                if (!bl) continue;
                builder.append(component3);
                continue;
            }
            Component component4 = null;
            if (n > 1) {
                component4 = joinConfiguration.lastSeparatorIfSerial();
            }
            if (component4 == null) {
                component4 = joinConfiguration.lastSeparator();
            }
            if (component4 == null) {
                component4 = joinConfiguration.separator();
            }
            if (component4 == null) continue;
            builder.append(component4);
        }
        if (component2 != null) {
            builder.append(component2);
        }
        return builder.build();
    }

    @NotNull
    static Component singleElementJoin(@NotNull JoinConfiguration joinConfiguration, @Nullable ComponentLike componentLike) {
        Component component = joinConfiguration.prefix();
        Component component2 = joinConfiguration.suffix();
        Function<ComponentLike, Component> function = joinConfiguration.convertor();
        Predicate<ComponentLike> predicate = joinConfiguration.predicate();
        if (component == null && component2 == null) {
            if (componentLike == null || !predicate.test(componentLike)) {
                return Component.empty();
            }
            return function.apply(componentLike);
        }
        TextComponent.Builder builder = Component.text();
        if (component != null) {
            builder.append(component);
        }
        if (componentLike != null && predicate.test(componentLike)) {
            builder.append(function.apply(componentLike));
        }
        if (component2 != null) {
            builder.append(component2);
        }
        return builder.build();
    }

    static final class BuilderImpl
    implements JoinConfiguration.Builder {
        private ComponentLike prefix;
        private ComponentLike suffix;
        private ComponentLike separator;
        private ComponentLike lastSeparator;
        private ComponentLike lastSeparatorIfSerial;
        private Function<ComponentLike, Component> convertor;
        private Predicate<ComponentLike> predicate;

        BuilderImpl() {
            this(NULL);
        }

        private BuilderImpl(@NotNull JoinConfigurationImpl joinConfigurationImpl) {
            this.separator = joinConfigurationImpl.separator;
            this.lastSeparator = joinConfigurationImpl.lastSeparator;
            this.prefix = joinConfigurationImpl.prefix;
            this.suffix = joinConfigurationImpl.suffix;
            this.convertor = joinConfigurationImpl.convertor;
            this.lastSeparatorIfSerial = joinConfigurationImpl.lastSeparatorIfSerial;
            this.predicate = joinConfigurationImpl.predicate;
        }

        @Override
        @NotNull
        public JoinConfiguration.Builder prefix(@Nullable ComponentLike componentLike) {
            this.prefix = componentLike;
            return this;
        }

        @Override
        @NotNull
        public JoinConfiguration.Builder suffix(@Nullable ComponentLike componentLike) {
            this.suffix = componentLike;
            return this;
        }

        @Override
        @NotNull
        public JoinConfiguration.Builder separator(@Nullable ComponentLike componentLike) {
            this.separator = componentLike;
            return this;
        }

        @Override
        @NotNull
        public JoinConfiguration.Builder lastSeparator(@Nullable ComponentLike componentLike) {
            this.lastSeparator = componentLike;
            return this;
        }

        @Override
        @NotNull
        public JoinConfiguration.Builder lastSeparatorIfSerial(@Nullable ComponentLike componentLike) {
            this.lastSeparatorIfSerial = componentLike;
            return this;
        }

        @Override
        @NotNull
        public JoinConfiguration.Builder convertor(@NotNull Function<ComponentLike, Component> function) {
            this.convertor = Objects.requireNonNull(function, "convertor");
            return this;
        }

        @Override
        @NotNull
        public JoinConfiguration.Builder predicate(@NotNull Predicate<ComponentLike> predicate) {
            this.predicate = Objects.requireNonNull(predicate, "predicate");
            return this;
        }

        @Override
        @NotNull
        public JoinConfiguration build() {
            return new JoinConfigurationImpl(this);
        }
    }
}

