/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.TextComponent;
import ld-shaded.net.kyori.adventure.text.TextComponentImpl;
import ld-shaded.net.kyori.adventure.text.format.Style;
import ld-shaded.net.kyori.adventure.text.format.TextDecoration;
import ld-shaded.net.kyori.adventure.util.Buildable;
import ld-shaded.net.kyori.examination.Examinable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ComponentCompaction {
    private static final TextDecoration[] DECORATIONS = TextDecoration.values();

    private ComponentCompaction() {
    }

    static Component compact(@NotNull Component component, @Nullable Style style) {
        Examinable examinable;
        int n;
        Buildable<Style, Style.Builder> buildable;
        int n2;
        List<Component> list = component.children();
        Component component2 = component.children(Collections.emptyList());
        if (style != null) {
            component2 = component2.style(ComponentCompaction.simplifyStyle(component.style(), style));
        }
        if ((n2 = list.size()) == 0) {
            return component2;
        }
        if (n2 == 1 && component instanceof TextComponent && (buildable = (TextComponent)component).content().isEmpty()) {
            Component component3 = list.get(0);
            return component3.style(component3.style().merge(component2.style(), Style.Merge.Strategy.IF_ABSENT_ON_TARGET)).compact();
        }
        buildable = component2.style();
        if (style != null) {
            buildable = buildable.merge(style, Style.Merge.Strategy.IF_ABSENT_ON_TARGET);
        }
        ArrayList<Component> arrayList = new ArrayList<Component>(list.size());
        for (n = 0; n < list.size(); ++n) {
            arrayList.add(ComponentCompaction.compact(list.get(n), buildable));
        }
        while (!arrayList.isEmpty()) {
            Component component4 = (Component)arrayList.get(0);
            examinable = component4.style().merge((Style)buildable, Style.Merge.Strategy.IF_ABSENT_ON_TARGET);
            if (!(component2 instanceof TextComponent) || !(component4 instanceof TextComponent) || !Objects.equals(examinable, buildable)) break;
            component2 = ComponentCompaction.joinText((TextComponent)component2, (TextComponent)component4);
            arrayList.remove(0);
            arrayList.addAll(0, component4.children());
        }
        n = 0;
        while (n + 1 < arrayList.size()) {
            examinable = (Component)arrayList.get(n);
            Component component5 = (Component)arrayList.get(n + 1);
            Style style2 = examinable.style().merge((Style)buildable, Style.Merge.Strategy.IF_ABSENT_ON_TARGET);
            Style style3 = component5.style().merge((Style)buildable, Style.Merge.Strategy.IF_ABSENT_ON_TARGET);
            if (examinable.children().isEmpty() && examinable instanceof TextComponent && component5 instanceof TextComponent && style2.equals(style3)) {
                TextComponent textComponent = ComponentCompaction.joinText((TextComponent)examinable, (TextComponent)component5);
                arrayList.set(n, textComponent);
                arrayList.remove(n + 1);
                continue;
            }
            ++n;
        }
        return component2.children(arrayList);
    }

    @NotNull
    private static Style simplifyStyle(@NotNull Style style, @NotNull Style style2) {
        if (style.isEmpty()) {
            return style;
        }
        Style.Builder builder = style.toBuilder();
        if (Objects.equals(style.font(), style2.font())) {
            builder.font(null);
        }
        if (Objects.equals(style.color(), style2.color())) {
            builder.color(null);
        }
        for (TextDecoration textDecoration : DECORATIONS) {
            if (style.decoration(textDecoration) != style2.decoration(textDecoration)) continue;
            builder.decoration(textDecoration, TextDecoration.State.NOT_SET);
        }
        if (Objects.equals(style.clickEvent(), style2.clickEvent())) {
            builder.clickEvent(null);
        }
        if (Objects.equals(style.hoverEvent(), style2.hoverEvent())) {
            builder.hoverEvent(null);
        }
        if (Objects.equals(style.insertion(), style2.insertion())) {
            builder.insertion(null);
        }
        return builder.build();
    }

    private static TextComponent joinText(TextComponent textComponent, TextComponent textComponent2) {
        return new TextComponentImpl(textComponent2.children(), textComponent.style(), textComponent.content() + textComponent2.content());
    }
}

