/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.ComponentCompaction;
import ld-shaded.net.kyori.adventure.text.ComponentLike;
import ld-shaded.net.kyori.adventure.text.TextReplacementConfig;
import ld-shaded.net.kyori.adventure.text.TextReplacementConfigImpl;
import ld-shaded.net.kyori.adventure.text.TextReplacementRenderer;
import ld-shaded.net.kyori.adventure.text.format.Style;
import ld-shaded.net.kyori.adventure.util.Buildable;
import ld-shaded.net.kyori.examination.ExaminableProperty;
import ld-shaded.net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Debug.Renderer(text="this.debuggerString()", childrenArray="this.children().toArray()", hasChildren="!this.children().isEmpty()")
public abstract class AbstractComponent
implements Component {
    private static final Predicate<Component> NOT_EMPTY = component -> component != Component.empty();
    protected final List<Component> children;
    protected final Style style;

    protected AbstractComponent(@NotNull List<? extends ComponentLike> list, @NotNull Style style) {
        this.children = ComponentLike.asComponents(list, NOT_EMPTY);
        this.style = style;
    }

    @Override
    @NotNull
    public final List<Component> children() {
        return this.children;
    }

    @Override
    @NotNull
    public final Style style() {
        return this.style;
    }

    @Override
    @NotNull
    public Component replaceText(@NotNull Consumer<TextReplacementConfig.Builder> consumer) {
        Objects.requireNonNull(consumer, "configurer");
        return this.replaceText((TextReplacementConfig)Buildable.configureAndBuild(TextReplacementConfig.builder(), consumer));
    }

    @Override
    @NotNull
    public Component replaceText(@NotNull TextReplacementConfig textReplacementConfig) {
        Objects.requireNonNull(textReplacementConfig, "replacement");
        if (!(textReplacementConfig instanceof TextReplacementConfigImpl)) {
            throw new IllegalArgumentException("Provided replacement was a custom TextReplacementConfig implementation, which is not supported.");
        }
        return TextReplacementRenderer.INSTANCE.render((Component)this, ((TextReplacementConfigImpl)textReplacementConfig).createState());
    }

    @Override
    @NotNull
    public Component compact() {
        return ComponentCompaction.compact(this, null);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractComponent)) {
            return false;
        }
        AbstractComponent abstractComponent = (AbstractComponent)object;
        return Objects.equals(this.children, abstractComponent.children) && Objects.equals(this.style, abstractComponent.style);
    }

    public int hashCode() {
        int n = this.children.hashCode();
        n = 31 * n + this.style.hashCode();
        return n;
    }

    private String debuggerString() {
        return (String)StringExaminer.simpleEscaping().examine(this.examinableName(), this.examinablePropertiesWithoutChildren());
    }

    protected Stream<? extends ExaminableProperty> examinablePropertiesWithoutChildren() {
        return Stream.of(ExaminableProperty.of("style", this.style));
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.concat(this.examinablePropertiesWithoutChildren(), Stream.of(ExaminableProperty.of("children", this.children)));
    }

    public String toString() {
        return this.examine(StringExaminer.simpleEscaping());
    }
}

