/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.key;

import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.stream.Stream;
import ld-shaded.net.kyori.adventure.key.InvalidKeyException;
import ld-shaded.net.kyori.adventure.key.Key;
import ld-shaded.net.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

final class KeyImpl
implements Key {
    static final String NAMESPACE_PATTERN = "[a-z0-9_\\-.]+";
    static final String VALUE_PATTERN = "[a-z0-9_\\-./]+";
    private static final IntPredicate NAMESPACE_PREDICATE = n -> n == 95 || n == 45 || n >= 97 && n <= 122 || n >= 48 && n <= 57 || n == 46;
    private static final IntPredicate VALUE_PREDICATE = n -> n == 95 || n == 45 || n >= 97 && n <= 122 || n >= 48 && n <= 57 || n == 47 || n == 46;
    private final String namespace;
    private final String value;

    KeyImpl(@NotNull String string, @NotNull String string2) {
        if (!KeyImpl.namespaceValid(string)) {
            throw new InvalidKeyException(string, string2, String.format("Non [a-z0-9_.-] character in namespace of Key[%s]", KeyImpl.asString(string, string2)));
        }
        if (!KeyImpl.valueValid(string2)) {
            throw new InvalidKeyException(string, string2, String.format("Non [a-z0-9/._-] character in value of Key[%s]", KeyImpl.asString(string, string2)));
        }
        this.namespace = Objects.requireNonNull(string, "namespace");
        this.value = Objects.requireNonNull(string2, "value");
    }

    @VisibleForTesting
    static boolean namespaceValid(@NotNull String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (NAMESPACE_PREDICATE.test(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    static boolean valueValid(@NotNull String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (VALUE_PREDICATE.test(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public String namespace() {
        return this.namespace;
    }

    @Override
    @NotNull
    public String value() {
        return this.value;
    }

    @Override
    @NotNull
    public String asString() {
        return KeyImpl.asString(this.namespace, this.value);
    }

    @NotNull
    private static String asString(@NotNull String string, @NotNull String string2) {
        return string + ':' + string2;
    }

    @NotNull
    public String toString() {
        return this.asString();
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("namespace", this.namespace), ExaminableProperty.of("value", this.value));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Key)) {
            return false;
        }
        Key key = (Key)object;
        return Objects.equals(this.namespace, key.namespace()) && Objects.equals(this.value, key.value());
    }

    public int hashCode() {
        int n = this.namespace.hashCode();
        n = 31 * n + this.value.hashCode();
        return n;
    }

    @Override
    public int compareTo(@NotNull Key key) {
        return Key.super.compareTo(key);
    }

    static int clampCompare(int n) {
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        return n;
    }
}

