/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.variables;

import com.typewritermc.basic.entries.variables.RangedVariableData;
import com.typewritermc.core.extension.annotations.Entry;
import com.typewritermc.core.extension.annotations.GenericConstraint;
import com.typewritermc.core.extension.annotations.VariableData;
import com.typewritermc.core.utils.point.Generic;
import com.typewritermc.engine.paper.entry.entries.VarContext;
import com.typewritermc.engine.paper.entry.entries.VariableEntry;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.jetbrains.annotations.NotNull;

@Entry(name="ranged_variable", description="A variable which returns a random value in a range", color="#4CAF50", icon="mdi:code-tags")
@GenericConstraint.Container(value={@GenericConstraint(type=int.class), @GenericConstraint(type=double.class), @GenericConstraint(type=Duration.class)})
@VariableData(type=RangedVariableData.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J%\u0010\n\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/typewritermc/basic/entries/variables/RangedVariable;", "Lcom/typewritermc/engine/paper/entry/entries/VariableEntry;", "id", "", "name", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getName", "get", "T", "", "context", "Lcom/typewritermc/engine/paper/entry/entries/VarContext;", "(Lcom/typewritermc/engine/paper/entry/entries/VarContext;)Ljava/lang/Object;", "BasicExtension"})
@SourceDebugExtension(value={"SMAP\nRangedVariable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RangedVariable.kt\ncom/typewritermc/basic/entries/variables/RangedVariable\n+ 2 VariableEntry.kt\ncom/typewritermc/engine/paper/entry/entries/VariableEntryKt\n*L\n1#1,70:1\n35#2:71\n*S KotlinDebug\n*F\n+ 1 RangedVariable.kt\ncom/typewritermc/basic/entries/variables/RangedVariable\n*L\n26#1:71\n*E\n"})
public final class RangedVariable
implements VariableEntry {
    @NotNull
    private final String id;
    @NotNull
    private final String name;

    public RangedVariable(@NotNull String id, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.id = id;
        this.name = name;
    }

    public /* synthetic */ RangedVariable(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        this(string, string2);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public <T> T get(@NotNull VarContext<T> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        VarContext<T> $this$getData$iv = context;
        boolean $i$f$getData = false;
        RangedVariableData rangedVariableData = (RangedVariableData)$this$getData$iv.getData(RangedVariableData.class);
        if (rangedVariableData == null) {
            throw new IllegalStateException("Could not find data for " + context.getKlass() + ", data: " + context.getData() + " for entry " + this.getId());
        }
        RangedVariableData data = rangedVariableData;
        KClass kClass = context.getKlass();
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            Integer n = (Integer)((Generic)data.getRange().getStart()).get(Reflection.getOrCreateKotlinClass(Integer.TYPE));
            int start = n != null ? n : 0;
            Integer n2 = (Integer)((Generic)data.getRange().getEndInclusive()).get(Reflection.getOrCreateKotlinClass(Integer.TYPE));
            int end = n2 != null ? n2 : 0;
            Integer n3 = (Integer)data.getStep().get(Reflection.getOrCreateKotlinClass(Integer.TYPE));
            int step = n3 != null ? n3 : 1;
            int numberOfSteps = (end - start) / step + 1;
            int randomStep = Random.Default.nextInt(numberOfSteps);
            int value = start + randomStep * step;
            Object object = KClasses.safeCast((KClass)context.getKlass(), (Object)value);
            Intrinsics.checkNotNull((Object)object);
            return (T)object;
        }
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            Double d = (Double)((Generic)data.getRange().getStart()).get(Reflection.getOrCreateKotlinClass(Double.TYPE));
            double start = d != null ? d : 0.0;
            Double d2 = (Double)((Generic)data.getRange().getEndInclusive()).get(Reflection.getOrCreateKotlinClass(Double.TYPE));
            double end = d2 != null ? d2 : 0.0;
            Double d3 = (Double)data.getStep().get(Reflection.getOrCreateKotlinClass(Double.TYPE));
            double step = d3 != null ? d3 : 1.0;
            int numberOfSteps = MathKt.roundToInt((double)((end - start) / step + 1.0));
            int randomStep = Random.Default.nextInt(numberOfSteps);
            double value = start + (double)randomStep * step;
            Object object = KClasses.safeCast((KClass)context.getKlass(), (Object)value);
            Intrinsics.checkNotNull((Object)object);
            return (T)object;
        }
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Duration.class))) {
            Duration duration;
            Duration end;
            Duration duration2;
            Duration start;
            Duration duration3 = (Duration)((Generic)data.getRange().getStart()).get(Reflection.getOrCreateKotlinClass(Duration.class));
            if (duration3 == null) {
                duration3 = start = Duration.ZERO;
            }
            if ((duration2 = (Duration)((Generic)data.getRange().getEndInclusive()).get(Reflection.getOrCreateKotlinClass(Duration.class))) == null) {
                duration2 = end = Duration.ZERO;
            }
            if ((duration = (Duration)data.getStep().get(Reflection.getOrCreateKotlinClass(Duration.class))) == null) {
                duration = Duration.ZERO;
            }
            Duration step = duration;
            long startNanos = start.toNanos();
            long endNanos = end.toNanos();
            long stepNanos = step.toNanos();
            int numberOfSteps = (int)((endNanos - startNanos) / stepNanos + 1L);
            int randomStep = Random.Default.nextInt(numberOfSteps);
            long value = startNanos + (long)randomStep * stepNanos;
            Object object = KClasses.safeCast((KClass)context.getKlass(), (Object)Duration.ofNanos(value));
            Intrinsics.checkNotNull((Object)object);
            return (T)object;
        }
        throw new IllegalStateException("Could not find data for " + context.getKlass() + ", data: " + context.getData() + " for entry " + this.getId());
    }

    public RangedVariable() {
        this(null, null, 3, null);
    }
}

