/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.quest;

import com.typewritermc.basic.entries.quest.CompletableObjectiveKt;
import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.extension.annotations.Entry;
import com.typewritermc.core.extension.annotations.Help;
import com.typewritermc.engine.paper.entry.BaseEntryKt;
import com.typewritermc.engine.paper.entry.Criteria;
import com.typewritermc.engine.paper.entry.PlaceholderParser;
import com.typewritermc.engine.paper.entry.entries.AudienceEntry;
import com.typewritermc.engine.paper.entry.entries.AudienceFilter;
import com.typewritermc.engine.paper.entry.entries.ConstVar;
import com.typewritermc.engine.paper.entry.entries.ObjectiveEntry;
import com.typewritermc.engine.paper.entry.entries.QuestEntry;
import com.typewritermc.engine.paper.entry.entries.QuestEntryKt;
import com.typewritermc.engine.paper.entry.entries.Var;
import com.typewritermc.engine.paper.entry.entries.VariableEntryKt;
import com.typewritermc.engine.paper.extensions.placeholderapi.PlaceholderExpansionKt;
import com.typewritermc.engine.paper.utils.MiniMessagesKt;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entry(name="completable_objective", description="An objective that can show a completed stage", color="#8A2BE2", icon="fluent:clipboard-checkmark-16-filled")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0083\u0001\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0016\b\u0002\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\u00060\t\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f\u0012\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0012\u0010\u000e\u001a\u00020\u00032\b\u0010'\u001a\u0004\u0018\u00010(H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\"\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\u00060\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001bR\"\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001f\u0010\u001d\u001a\u0004\b \u0010\u001bR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001b\u00a8\u0006)"}, d2={"Lcom/typewritermc/basic/entries/quest/CompletableObjective;", "Lcom/typewritermc/engine/paper/entry/entries/ObjectiveEntry;", "id", "", "name", "quest", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/QuestEntry;", "children", "", "Lcom/typewritermc/engine/paper/entry/entries/AudienceEntry;", "showCriteria", "Lcom/typewritermc/engine/paper/entry/Criteria;", "completedCriteria", "display", "Lcom/typewritermc/engine/paper/entry/entries/Var;", "priorityOverride", "Ljava/util/Optional;", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/typewritermc/core/entries/Ref;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lcom/typewritermc/engine/paper/entry/entries/Var;Ljava/util/Optional;)V", "getId", "()Ljava/lang/String;", "getName", "getQuest", "()Lcom/typewritermc/core/entries/Ref;", "getChildren", "()Ljava/util/List;", "getShowCriteria$annotations", "()V", "getShowCriteria", "getCompletedCriteria$annotations", "getCompletedCriteria", "getDisplay", "()Lcom/typewritermc/engine/paper/entry/entries/Var;", "getPriorityOverride", "()Ljava/util/Optional;", "criteria", "getCriteria", "player", "Lorg/bukkit/entity/Player;", "BasicExtension"})
@SourceDebugExtension(value={"SMAP\nCompletableObjective.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompletableObjective.kt\ncom/typewritermc/basic/entries/quest/CompletableObjective\n+ 2 EntryReference.kt\ncom/typewritermc/core/entries/EntryReferenceKt\n*L\n1#1,64:1\n6#2:65\n*S KotlinDebug\n*F\n+ 1 CompletableObjective.kt\ncom/typewritermc/basic/entries/quest/CompletableObjective\n*L\n44#1:65\n*E\n"})
public final class CompletableObjective
implements ObjectiveEntry {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final Ref<QuestEntry> quest;
    @NotNull
    private final List<Ref<? extends AudienceEntry>> children;
    @NotNull
    private final List<Criteria> showCriteria;
    @NotNull
    private final List<Criteria> completedCriteria;
    @NotNull
    private final Var<String> display;
    @NotNull
    private final Optional<Integer> priorityOverride;

    public CompletableObjective(@NotNull String id, @NotNull String name, @NotNull Ref<QuestEntry> quest, @NotNull List<? extends Ref<? extends AudienceEntry>> children, @NotNull List<Criteria> showCriteria, @NotNull List<Criteria> completedCriteria, @NotNull Var<String> display, @NotNull Optional<Integer> priorityOverride) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(quest, (String)"quest");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(showCriteria, (String)"showCriteria");
        Intrinsics.checkNotNullParameter(completedCriteria, (String)"completedCriteria");
        Intrinsics.checkNotNullParameter(display, (String)"display");
        Intrinsics.checkNotNullParameter(priorityOverride, (String)"priorityOverride");
        this.id = id;
        this.name = name;
        this.quest = quest;
        this.children = children;
        this.showCriteria = showCriteria;
        this.completedCriteria = completedCriteria;
        this.display = display;
        this.priorityOverride = priorityOverride;
    }

    public /* synthetic */ CompletableObjective(String string, String string2, Ref ref, List list, List list2, List list3, Var var, Optional optional2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            boolean $i$f$emptyRef = false;
            ref = new Ref("", Reflection.getOrCreateKotlinClass(QuestEntry.class));
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            var = (Var)new ConstVar((Object)"");
        }
        if ((n & 0x80) != 0) {
            optional2 = Optional.empty();
        }
        this(string, string2, (Ref<QuestEntry>)ref, list, list2, list3, (Var<String>)var, optional2);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Ref<QuestEntry> getQuest() {
        return this.quest;
    }

    @NotNull
    public List<Ref<? extends AudienceEntry>> getChildren() {
        return this.children;
    }

    @NotNull
    public final List<Criteria> getShowCriteria() {
        return this.showCriteria;
    }

    @Help(text="The criteria need to be met for the objective to be able to be shown.")
    public static /* synthetic */ void getShowCriteria$annotations() {
    }

    @NotNull
    public final List<Criteria> getCompletedCriteria() {
        return this.completedCriteria;
    }

    @Help(text="The criteria to display the objective as completed.")
    public static /* synthetic */ void getCompletedCriteria$annotations() {
    }

    @NotNull
    public Var<String> getDisplay() {
        return this.display;
    }

    @NotNull
    public Optional<Integer> getPriorityOverride() {
        return this.priorityOverride;
    }

    @NotNull
    public List<Criteria> getCriteria() {
        return this.showCriteria;
    }

    @NotNull
    public String display(@Nullable Player player) {
        String text = player == null ? QuestEntryKt.getInactiveObjectiveDisplay() : (BaseEntryKt.matches((Iterable)this.completedCriteria, (Player)player) ? CompletableObjectiveKt.access$getCompletedObjectiveDisplay() : (BaseEntryKt.matches((Iterable)this.showCriteria, (Player)player) ? QuestEntryKt.getShowingObjectiveDisplay() : QuestEntryKt.getInactiveObjectiveDisplay()));
        TagResolver[] tagResolverArray = new TagResolver[1];
        String string = (String)VariableEntryKt.get(this.getDisplay(), (Player)player);
        if (string == null) {
            string = "";
        }
        tagResolverArray[0] = Placeholder.parsed((String)"display", (String)string);
        return PlaceholderExpansionKt.parsePlaceholders((String)MiniMessagesKt.asMini((Component)MiniMessagesKt.asMiniWithResolvers((String)text, (TagResolver[])tagResolverArray)), (Player)player);
    }

    @NotNull
    public AudienceFilter display() {
        return ObjectiveEntry.DefaultImpls.display((ObjectiveEntry)this);
    }

    @NotNull
    public PlaceholderParser parser() {
        return ObjectiveEntry.DefaultImpls.parser((ObjectiveEntry)this);
    }

    public CompletableObjective() {
        this(null, null, null, null, null, null, null, null, 255, null);
    }
}

