/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.fact;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.extension.annotations.Entry;
import com.typewritermc.core.utils.DurationFormatKt;
import com.typewritermc.engine.paper.entry.ParsingContext;
import com.typewritermc.engine.paper.entry.PlaceholderEntryKt;
import com.typewritermc.engine.paper.entry.PlaceholderNodeBuilder;
import com.typewritermc.engine.paper.entry.PlaceholderParser;
import com.typewritermc.engine.paper.entry.entries.ExpirableFactEntry;
import com.typewritermc.engine.paper.entry.entries.GroupEntry;
import com.typewritermc.engine.paper.entry.entries.PersistableFactEntry;
import com.typewritermc.engine.paper.facts.FactData;
import com.typewritermc.engine.paper.facts.FactId;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Entry(name="countdown_fact", description="A fact that counts down from the set value", color="#5843e6", icon="material-symbols:person-pin")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B5\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/typewritermc/basic/entries/fact/CountdownFact;", "Lcom/typewritermc/engine/paper/entry/entries/PersistableFactEntry;", "Lcom/typewritermc/engine/paper/entry/entries/ExpirableFactEntry;", "id", "", "name", "comment", "group", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/GroupEntry;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/typewritermc/core/entries/Ref;)V", "getId", "()Ljava/lang/String;", "getName", "getComment", "getGroup", "()Lcom/typewritermc/core/entries/Ref;", "read", "Lcom/typewritermc/engine/paper/facts/FactData;", "Lcom/typewritermc/engine/paper/facts/FactId;", "hasExpired", "", "data", "calculateValue", "", "parser", "Lcom/typewritermc/engine/paper/entry/PlaceholderParser;", "BasicExtension"})
@SourceDebugExtension(value={"SMAP\nCountdownFact.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CountdownFact.kt\ncom/typewritermc/basic/entries/fact/CountdownFact\n+ 2 EntryReference.kt\ncom/typewritermc/core/entries/EntryReferenceKt\n*L\n1#1,84:1\n6#2:85\n*S KotlinDebug\n*F\n+ 1 CountdownFact.kt\ncom/typewritermc/basic/entries/fact/CountdownFact\n*L\n44#1:85\n*E\n"})
public final class CountdownFact
implements PersistableFactEntry,
ExpirableFactEntry {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final String comment;
    @NotNull
    private final Ref<GroupEntry> group;

    public CountdownFact(@NotNull String id, @NotNull String name, @NotNull String comment, @NotNull Ref<GroupEntry> group2) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        Intrinsics.checkNotNullParameter(group2, (String)"group");
        this.id = id;
        this.name = name;
        this.comment = comment;
        this.group = group2;
    }

    public /* synthetic */ CountdownFact(String string, String string2, String string3, Ref ref, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            boolean $i$f$emptyRef = false;
            ref = new Ref("", Reflection.getOrCreateKotlinClass(GroupEntry.class));
        }
        this(string, string2, string3, (Ref<GroupEntry>)ref);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getComment() {
        return this.comment;
    }

    @NotNull
    public Ref<GroupEntry> getGroup() {
        return this.group;
    }

    @NotNull
    public FactData read(@NotNull FactId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        FactData data = PersistableFactEntry.DefaultImpls.read((PersistableFactEntry)this, (FactId)id);
        return new FactData(this.calculateValue(data), data.getLastUpdate());
    }

    public boolean hasExpired(@NotNull FactId id, @NotNull FactData data) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.calculateValue(data) == 0;
    }

    private final int calculateValue(FactData data) {
        Duration timeDifference = Duration.between(data.getLastUpdate(), LocalDateTime.now());
        return Math.max(0, (int)((long)data.getValue() - timeDifference.getSeconds()));
    }

    @NotNull
    public PlaceholderParser parser() {
        return PlaceholderEntryKt.placeholderParser(arg_0 -> CountdownFact.parser$lambda$5(this, arg_0));
    }

    public boolean canPersist(@NotNull FactId id, @NotNull FactData data) {
        return PersistableFactEntry.DefaultImpls.canPersist((PersistableFactEntry)this, (FactId)id, (FactData)data);
    }

    @NotNull
    public FactData readForGroup-1dlmaes(@NotNull String groupId) {
        return PersistableFactEntry.DefaultImpls.readForGroup-1dlmaes((PersistableFactEntry)this, (String)groupId);
    }

    @NotNull
    public FactData readSinglePlayer(@NotNull Player player) {
        return PersistableFactEntry.DefaultImpls.readSinglePlayer((PersistableFactEntry)this, (Player)player);
    }

    public void write(@NotNull FactId id, int value) {
        PersistableFactEntry.DefaultImpls.write((PersistableFactEntry)this, (FactId)id, (int)value);
    }

    public void write(@NotNull Player player, int value) {
        PersistableFactEntry.DefaultImpls.write((PersistableFactEntry)this, (Player)player, (int)value);
    }

    public boolean canCache(@NotNull FactId id, @NotNull FactData factData) {
        return PersistableFactEntry.DefaultImpls.canCache((PersistableFactEntry)this, (FactId)id, (FactData)factData);
    }

    @NotNull
    public FactData readForPlayersGroup(@NotNull Player player) {
        return PersistableFactEntry.DefaultImpls.readForPlayersGroup((PersistableFactEntry)this, (Player)player);
    }

    @Nullable
    public FactId identifier(@NotNull Player player) {
        return PersistableFactEntry.DefaultImpls.identifier((PersistableFactEntry)this, (Player)player);
    }

    private static final String parser$lambda$5$lambda$4$lambda$3$lambda$1$lambda$0(CountdownFact this$0, ParsingContext $this$supplyPlayer, Player player) {
        Intrinsics.checkNotNullParameter((Object)$this$supplyPlayer, (String)"$this$supplyPlayer");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        FactData data = this$0.readForPlayersGroup(player);
        long duration = DurationKt.toDuration((int)data.getValue(), (DurationUnit)DurationUnit.SECONDS);
        return DurationFormatKt.formatCompact-LRDsOJo((long)duration);
    }

    private static final Unit parser$lambda$5$lambda$4$lambda$3$lambda$1(CountdownFact this$0, PlaceholderNodeBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        PlaceholderEntryKt.supplyPlayer((PlaceholderNodeBuilder)$this$literal, (arg_0, arg_1) -> CountdownFact.parser$lambda$5$lambda$4$lambda$3$lambda$1$lambda$0(this$0, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final String parser$lambda$5$lambda$4$lambda$3$lambda$2(CountdownFact this$0, ParsingContext $this$supplyPlayer, Player player) {
        Intrinsics.checkNotNullParameter((Object)$this$supplyPlayer, (String)"$this$supplyPlayer");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        FactData data = this$0.readForPlayersGroup(player);
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime expireTime = now.plusSeconds(data.getValue());
        return expireTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    private static final Unit parser$lambda$5$lambda$4$lambda$3(CountdownFact this$0, PlaceholderNodeBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        PlaceholderEntryKt.literal((PlaceholderNodeBuilder)$this$literal, (String)"relative", arg_0 -> CountdownFact.parser$lambda$5$lambda$4$lambda$3$lambda$1(this$0, arg_0));
        PlaceholderEntryKt.supplyPlayer((PlaceholderNodeBuilder)$this$literal, (arg_0, arg_1) -> CountdownFact.parser$lambda$5$lambda$4$lambda$3$lambda$2(this$0, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final Unit parser$lambda$5$lambda$4(CountdownFact this$0, PlaceholderNodeBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        PlaceholderEntryKt.literal((PlaceholderNodeBuilder)$this$literal, (String)"expires", arg_0 -> CountdownFact.parser$lambda$5$lambda$4$lambda$3(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit parser$lambda$5(CountdownFact this$0, PlaceholderNodeBuilder $this$placeholderParser) {
        Intrinsics.checkNotNullParameter((Object)$this$placeholderParser, (String)"$this$placeholderParser");
        PlaceholderEntryKt.include((PlaceholderNodeBuilder)$this$placeholderParser, (PlaceholderParser)ExpirableFactEntry.DefaultImpls.parser((ExpirableFactEntry)this$0));
        PlaceholderEntryKt.literal((PlaceholderNodeBuilder)$this$placeholderParser, (String)"time", arg_0 -> CountdownFact.parser$lambda$5$lambda$4(this$0, arg_0));
        return Unit.INSTANCE;
    }

    public CountdownFact() {
        this(null, null, null, null, 15, null);
    }
}

