/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.dialogue.messengers.spoken;

import com.typewritermc.basic.entries.dialogue.SpokenDialogueEntry;
import com.typewritermc.basic.entries.dialogue.messengers.spoken.JavaSpokenDialogueDialogueMessengerKt;
import com.typewritermc.core.extension.annotations.Messenger;
import com.typewritermc.engine.paper.entry.dialogue.ConfirmationKey;
import com.typewritermc.engine.paper.entry.dialogue.DialogueMessenger;
import com.typewritermc.engine.paper.entry.dialogue.MessengerFilter;
import com.typewritermc.engine.paper.entry.dialogue.MessengerFinderKt;
import com.typewritermc.engine.paper.entry.dialogue.MessengerState;
import com.typewritermc.engine.paper.entry.dialogue.TickContext;
import com.typewritermc.engine.paper.entry.entries.DialogueEntry;
import com.typewritermc.engine.paper.extensions.placeholderapi.PlaceholderExpansionKt;
import com.typewritermc.engine.paper.utils.MiniMessagesKt;
import java.time.Duration;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

@Messenger(dialogue=SpokenDialogueEntry.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0018\u0010\u000f\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lcom/typewritermc/basic/entries/dialogue/messengers/spoken/JavaSpokenDialogueDialogueMessenger;", "Lcom/typewritermc/engine/paper/entry/dialogue/DialogueMessenger;", "Lcom/typewritermc/basic/entries/dialogue/SpokenDialogueEntry;", "player", "Lorg/bukkit/entity/Player;", "entry", "<init>", "(Lorg/bukkit/entity/Player;Lcom/typewritermc/basic/entries/dialogue/SpokenDialogueEntry;)V", "speakerDisplayName", "", "text", "typingDuration", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "Ljava/time/Duration;", "playedTime", "value", "", "isCompleted", "()Z", "setCompleted", "(Z)V", "init", "", "tick", "context", "Lcom/typewritermc/engine/paper/entry/dialogue/TickContext;", "Companion", "BasicExtension"})
public final class JavaSpokenDialogueDialogueMessenger
extends DialogueMessenger<SpokenDialogueEntry> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String speakerDisplayName;
    @NotNull
    private String text;
    private Duration typingDuration;
    private Duration playedTime;

    public JavaSpokenDialogueDialogueMessenger(@NotNull Player player, @NotNull SpokenDialogueEntry entry) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        super(player, (DialogueEntry)entry);
        this.speakerDisplayName = "";
        this.text = "";
        this.typingDuration = Duration.ZERO;
        this.playedTime = Duration.ZERO;
    }

    public boolean isCompleted() {
        return this.playedTime.compareTo(this.typingDuration) >= 0;
    }

    public void setCompleted(boolean value) {
        this.playedTime = !value ? Duration.ZERO : this.typingDuration;
    }

    public void init() {
        super.init();
        this.speakerDisplayName = PlaceholderExpansionKt.parsePlaceholders((String)((String)((SpokenDialogueEntry)this.getEntry()).getSpeakerDisplayName().get(this.getPlayer())), (Player)this.getPlayer());
        this.text = PlaceholderExpansionKt.parsePlaceholders((String)((String)((SpokenDialogueEntry)this.getEntry()).getText().get(this.getPlayer())), (Player)this.getPlayer());
        this.typingDuration = MessengerFinderKt.getTypingDurationType().totalDuration(MiniMessagesKt.stripped((String)this.text), (Duration)((SpokenDialogueEntry)this.getEntry()).getDuration().get(this.getPlayer()));
        ConfirmationKey confirmationKey = MessengerFinderKt.getConfirmationKey();
        Listener listener = (Listener)this;
        UUID uUID = this.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        confirmationKey.listen(listener, uUID, () -> JavaSpokenDialogueDialogueMessenger.init$lambda$0(this));
    }

    public void tick(@NotNull TickContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.getState() != MessengerState.RUNNING) {
            return;
        }
        this.playedTime = this.playedTime.plus(context.getDeltaTime());
        Player player = this.getPlayer();
        Duration duration = (Duration)((SpokenDialogueEntry)this.getEntry()).getDuration().get(this.getPlayer());
        Duration duration2 = this.playedTime;
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"playedTime");
        JavaSpokenDialogueDialogueMessengerKt.sendSpokenDialogue(player, this.text, this.speakerDisplayName, duration, duration2, this.getTriggers().isEmpty());
    }

    private static final Unit init$lambda$0(JavaSpokenDialogueDialogueMessenger this$0) {
        this$0.completeOrFinish();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/typewritermc/basic/entries/dialogue/messengers/spoken/JavaSpokenDialogueDialogueMessenger$Companion;", "Lcom/typewritermc/engine/paper/entry/dialogue/MessengerFilter;", "<init>", "()V", "filter", "", "player", "Lorg/bukkit/entity/Player;", "entry", "Lcom/typewritermc/engine/paper/entry/entries/DialogueEntry;", "BasicExtension"})
    public static final class Companion
    implements MessengerFilter {
        private Companion() {
        }

        public boolean filter(@NotNull Player player, @NotNull DialogueEntry entry) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

