/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.dialogue.messengers.option;

import com.typewritermc.basic.entries.dialogue.Option;
import com.typewritermc.basic.entries.dialogue.OptionDialogueEntry;
import com.typewritermc.basic.entries.dialogue.messengers.option.JavaOptionDialogueDialogueMessengerKt;
import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.extension.annotations.Messenger;
import com.typewritermc.core.utils.LoopingKt;
import com.typewritermc.engine.paper.entry.BaseEntryKt;
import com.typewritermc.engine.paper.entry.Modifier;
import com.typewritermc.engine.paper.entry.TriggerableEntry;
import com.typewritermc.engine.paper.entry.dialogue.ConfirmationKey;
import com.typewritermc.engine.paper.entry.dialogue.DialogueMessenger;
import com.typewritermc.engine.paper.entry.dialogue.MessengerFilter;
import com.typewritermc.engine.paper.entry.dialogue.MessengerFinderKt;
import com.typewritermc.engine.paper.entry.dialogue.MessengerState;
import com.typewritermc.engine.paper.entry.dialogue.TickContext;
import com.typewritermc.engine.paper.entry.entries.DialogueEntry;
import com.typewritermc.engine.paper.extensions.placeholderapi.PlaceholderExpansionKt;
import com.typewritermc.engine.paper.interaction.ChatHistory;
import com.typewritermc.engine.paper.interaction.ChatHistoryHandlerKt;
import com.typewritermc.engine.paper.utils.ExtensionsKt;
import com.typewritermc.engine.paper.utils.MiniMessagesKt;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.jetbrains.annotations.NotNull;

@Messenger(dialogue=OptionDialogueEntry.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 42\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00014B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,H\u0003J\u0010\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020)2\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0013H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0015\u001a\n \u0016*\u0004\u0018\u00010\t0\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0018\u0010\u0018\u001a\n \u0016*\u0004\u0018\u00010\t0\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u001b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c0\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001fR$\u0010$\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u001a8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u00065"}, d2={"Lcom/typewritermc/basic/entries/dialogue/messengers/option/JavaOptionDialogueDialogueMessenger;", "Lcom/typewritermc/engine/paper/entry/dialogue/DialogueMessenger;", "Lcom/typewritermc/basic/entries/dialogue/OptionDialogueEntry;", "player", "Lorg/bukkit/entity/Player;", "entry", "<init>", "(Lorg/bukkit/entity/Player;Lcom/typewritermc/basic/entries/dialogue/OptionDialogueEntry;)V", "typeDuration", "Ljava/time/Duration;", "selectedIndex", "", "selected", "Lcom/typewritermc/basic/entries/dialogue/Option;", "getSelected", "()Lcom/typewritermc/basic/entries/dialogue/Option;", "usableOptions", "", "speakerDisplayName", "", "parsedText", "playTime", "kotlin.jvm.PlatformType", "Ljava/time/Duration;", "totalDuration", "completedAnimation", "", "triggers", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/TriggerableEntry;", "getTriggers", "()Ljava/util/List;", "modifiers", "Lcom/typewritermc/engine/paper/entry/Modifier;", "getModifiers", "value", "isCompleted", "()Z", "setCompleted", "(Z)V", "init", "", "onPlayerItemHeld", "event", "Lorg/bukkit/event/player/PlayerItemHeldEvent;", "tick", "context", "Lcom/typewritermc/engine/paper/entry/dialogue/TickContext;", "displayMessage", "formatOptions", "Lnet/kyori/adventure/text/Component;", "rawText", "Companion", "BasicExtension"})
@SourceDebugExtension(value={"SMAP\nJavaOptionDialogueDialogueMessenger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaOptionDialogueDialogueMessenger.kt\ncom/typewritermc/basic/entries/dialogue/messengers/option/JavaOptionDialogueDialogueMessenger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,212:1\n774#2:213\n865#2,2:214\n*S KotlinDebug\n*F\n+ 1 JavaOptionDialogueDialogueMessenger.kt\ncom/typewritermc/basic/entries/dialogue/messengers/option/JavaOptionDialogueDialogueMessenger\n*L\n96#1:213\n96#1:214,2\n*E\n"})
public final class JavaOptionDialogueDialogueMessenger
extends DialogueMessenger<OptionDialogueEntry> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Duration typeDuration;
    private int selectedIndex;
    @NotNull
    private List<Option> usableOptions;
    @NotNull
    private String speakerDisplayName;
    @NotNull
    private String parsedText;
    private Duration playTime;
    private Duration totalDuration;
    private boolean completedAnimation;

    public JavaOptionDialogueDialogueMessenger(@NotNull Player player, @NotNull OptionDialogueEntry entry) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        super(player, (DialogueEntry)entry);
        this.typeDuration = (Duration)entry.getDuration().get(player);
        this.usableOptions = CollectionsKt.emptyList();
        this.speakerDisplayName = "";
        this.parsedText = "";
        this.playTime = Duration.ZERO;
        this.totalDuration = Duration.ZERO;
    }

    private final Option getSelected() {
        return (Option)CollectionsKt.getOrNull(this.usableOptions, (int)this.selectedIndex);
    }

    @NotNull
    public List<Ref<? extends TriggerableEntry>> getTriggers() {
        Object object;
        return CollectionsKt.plus((Collection)((OptionDialogueEntry)this.getEntry()).getTriggers(), (Iterable)((object = this.getSelected()) != null && (object = ((Option)object).getTriggers()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList()));
    }

    @NotNull
    public List<Modifier> getModifiers() {
        Object object;
        return CollectionsKt.plus((Collection)((OptionDialogueEntry)this.getEntry()).getModifiers(), (Iterable)((object = this.getSelected()) != null && (object = ((Option)object).getModifiers()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList()));
    }

    public boolean isCompleted() {
        return this.playTime.compareTo(this.totalDuration) >= 0;
    }

    public void setCompleted(boolean value) {
        this.playTime = !value ? Duration.ZERO : this.totalDuration;
    }

    /*
     * WARNING - void declaration
     */
    public void init() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = ((OptionDialogueEntry)this.getEntry()).getOptions();
        JavaOptionDialogueDialogueMessenger javaOptionDialogueDialogueMessenger = this;
        boolean $i$f$filter = false;
        void var3_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Option it = (Option)element$iv$iv;
            boolean bl = false;
            if (!BaseEntryKt.matches((Iterable)it.getCriteria(), (Player)this.getPlayer())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        javaOptionDialogueDialogueMessenger.usableOptions = (List)destination$iv$iv;
        if (this.usableOptions.isEmpty()) {
            return;
        }
        this.speakerDisplayName = PlaceholderExpansionKt.parsePlaceholders((String)((String)((OptionDialogueEntry)this.getEntry()).getSpeakerDisplayName().get(this.getPlayer())), (Player)this.getPlayer());
        this.parsedText = PlaceholderExpansionKt.parsePlaceholders((String)((String)((OptionDialogueEntry)this.getEntry()).getText().get(this.getPlayer())), (Player)this.getPlayer());
        String rawText = MiniMessagesKt.stripped((String)this.parsedText);
        Duration typingDuration = MessengerFinderKt.getTypingDurationType().totalDuration(rawText, this.typeDuration);
        Duration optionsShowingDuration = Duration.ofMillis((long)this.usableOptions.size() * (long)JavaOptionDialogueDialogueMessengerKt.access$getDelayOptionShow());
        this.totalDuration = typingDuration.plus(optionsShowingDuration);
        super.init();
        ConfirmationKey confirmationKey = MessengerFinderKt.getConfirmationKey();
        Listener listener = (Listener)this;
        UUID uUID = this.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        confirmationKey.listen(listener, uUID, () -> JavaOptionDialogueDialogueMessenger.init$lambda$1(this));
    }

    @EventHandler
    private final void onPlayerItemHeld(PlayerItemHeldEvent event) {
        int newIndex;
        if (!Intrinsics.areEqual((Object)event.getPlayer().getUniqueId(), (Object)this.getPlayer().getUniqueId())) {
            return;
        }
        int curSlot = event.getPreviousSlot();
        int newSlot = event.getNewSlot();
        int dif = LoopingKt.loopingDistance((int)curSlot, (int)newSlot, (int)8);
        int index = this.selectedIndex;
        event.setCancelled(true);
        for (newIndex = (index + dif) % this.usableOptions.size(); newIndex < 0; newIndex += this.usableOptions.size()) {
        }
        this.selectedIndex = newIndex;
        Duration duration = this.playTime;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"playTime");
        this.displayMessage(duration);
    }

    public void tick(@NotNull TickContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.tick(context);
        boolean isFirst = Intrinsics.areEqual((Object)this.playTime, (Object)Duration.ZERO);
        this.playTime = this.playTime.plus(context.getDeltaTime());
        if (this.getState() != MessengerState.RUNNING) {
            return;
        }
        if (this.usableOptions.isEmpty()) {
            this.setCompleted(true);
            this.setState(MessengerState.FINISHED);
            return;
        }
        Duration duration = this.playTime;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"playTime");
        if (ExtensionsKt.toTicks((Duration)duration) % (long)100 > 0L && this.completedAnimation && !isFirst) {
            return;
        }
        Duration duration2 = this.playTime;
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"playTime");
        this.displayMessage(duration2);
    }

    private final void displayMessage(Duration playTime) {
        String rawText = MiniMessagesKt.stripped((String)this.parsedText);
        double typePercentage = this.typeDuration.isZero() ? 1.0 : MessengerFinderKt.getTypingDurationType().calculatePercentage(playTime, this.typeDuration, rawText);
        int resultingLines = ExtensionsKt.getLineCount((String)MiniMessagesKt.limitLineLength((String)rawText, (int)JavaOptionDialogueDialogueMessengerKt.getOptionMaxLineLength()));
        String string = this.parsedText;
        int n = JavaOptionDialogueDialogueMessengerKt.getOptionMaxLineLength();
        Component text = MiniMessagesKt.asPartialFormattedMini((String)string, (double)typePercentage, (int)resultingLines, (int)n, (String)"");
        TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.parsed((String)"speaker", (String)this.speakerDisplayName), Placeholder.component((String)"text", (ComponentLike)((ComponentLike)text)), Placeholder.component((String)"options", (ComponentLike)((ComponentLike)this.formatOptions(rawText)))};
        Component message = MiniMessagesKt.asMiniWithResolvers((String)JavaOptionDialogueDialogueMessengerKt.getOptionFormat(), (TagResolver[])tagResolverArray);
        Component component = ChatHistory.composeDarkMessage$default((ChatHistory)ChatHistoryHandlerKt.getChatHistory((Player)this.getPlayer()), (Component)message, (boolean)false, (int)2, null);
        this.getPlayer().sendMessage(component);
    }

    private final Component formatOptions(String rawText) {
        int i;
        int showingOptions;
        List around = LoopingKt.around(this.usableOptions, (int)this.selectedIndex, (int)1, (int)2);
        List lines = new ArrayList();
        Duration typingDuration = MessengerFinderKt.getTypingDurationType().totalDuration(rawText, this.typeDuration);
        Duration timeAfterTyping = this.playTime.minus(typingDuration);
        int limitedOptions = RangesKt.coerceAtLeast((int)((int)(timeAfterTyping.toMillis() / (long)JavaOptionDialogueDialogueMessengerKt.access$getDelayOptionShow())), (int)0);
        int maxOptions = Math.min(4, around.size());
        this.completedAnimation = maxOptions == (showingOptions = Math.min(maxOptions, limitedOptions));
        for (i = 0; i < showingOptions; ++i) {
            Option option = (Option)around.get(i);
            boolean isSelected = Intrinsics.areEqual((Object)this.getSelected(), (Object)option);
            String prefix = isSelected ? JavaOptionDialogueDialogueMessengerKt.access$getSelectedPrefix() : (i == 0 && this.selectedIndex > 1 && this.usableOptions.size() > 4 ? JavaOptionDialogueDialogueMessengerKt.access$getUpPrefix() : (i == 3 && this.selectedIndex < this.usableOptions.size() - 3 && this.usableOptions.size() > 4 ? JavaOptionDialogueDialogueMessengerKt.access$getDownPrefix() : JavaOptionDialogueDialogueMessengerKt.access$getUnselectedPrefix()));
            String format = isSelected ? JavaOptionDialogueDialogueMessengerKt.access$getSelectedOption() : JavaOptionDialogueDialogueMessengerKt.access$getUnselectedOption();
            Collection collection = lines;
            TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.parsed((String)"prefix", (String)prefix), Placeholder.parsed((String)"option_text", (String)PlaceholderExpansionKt.parsePlaceholders((String)((String)option.getText().get(this.getPlayer())), (Player)this.getPlayer()))};
            collection.add(MiniMessagesKt.asMiniWithResolvers((String)format, (TagResolver[])tagResolverArray));
        }
        for (i = showingOptions; i < maxOptions; ++i) {
            ((Collection)lines).add(Component.text((String)" \n"));
        }
        Component component = Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (Iterable)lines);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"join(...)");
        return component;
    }

    private static final Unit init$lambda$1(JavaOptionDialogueDialogueMessenger this$0) {
        this$0.completeOrFinish();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/typewritermc/basic/entries/dialogue/messengers/option/JavaOptionDialogueDialogueMessenger$Companion;", "Lcom/typewritermc/engine/paper/entry/dialogue/MessengerFilter;", "<init>", "()V", "filter", "", "player", "Lorg/bukkit/entity/Player;", "entry", "Lcom/typewritermc/engine/paper/entry/entries/DialogueEntry;", "BasicExtension"})
    public static final class Companion
    implements MessengerFilter {
        private Companion() {
        }

        public boolean filter(@NotNull Player player, @NotNull DialogueEntry entry) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

