/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.dialogue.messengers.actionbar;

import com.typewritermc.basic.entries.dialogue.ActionBarDialogueEntry;
import com.typewritermc.basic.entries.dialogue.messengers.actionbar.JavaActionBarDialogueDialogueMessengerKt;
import com.typewritermc.core.extension.annotations.Messenger;
import com.typewritermc.engine.paper.entry.dialogue.ConfirmationKey;
import com.typewritermc.engine.paper.entry.dialogue.DialogueMessenger;
import com.typewritermc.engine.paper.entry.dialogue.MessengerFilter;
import com.typewritermc.engine.paper.entry.dialogue.MessengerFinderKt;
import com.typewritermc.engine.paper.entry.dialogue.MessengerState;
import com.typewritermc.engine.paper.entry.dialogue.TickContext;
import com.typewritermc.engine.paper.entry.dialogue.TypingDurationType;
import com.typewritermc.engine.paper.entry.entries.DialogueEntry;
import com.typewritermc.engine.paper.extensions.placeholderapi.PlaceholderExpansionKt;
import com.typewritermc.engine.paper.interaction.ActionBarBlockerKt;
import com.typewritermc.engine.paper.interaction.ChatHistory;
import com.typewritermc.engine.paper.interaction.ChatHistoryHandlerKt;
import com.typewritermc.engine.paper.utils.ExtensionsKt;
import com.typewritermc.engine.paper.utils.MiniMessagesKt;
import java.time.Duration;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

@Messenger(dialogue=ActionBarDialogueEntry.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0017H\u0016J\b\u0010\u001c\u001a\u00020\u0017H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0018\u0010\u000f\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lcom/typewritermc/basic/entries/dialogue/messengers/actionbar/JavaActionBarDialogueDialogueMessenger;", "Lcom/typewritermc/engine/paper/entry/dialogue/DialogueMessenger;", "Lcom/typewritermc/basic/entries/dialogue/ActionBarDialogueEntry;", "player", "Lorg/bukkit/entity/Player;", "entry", "<init>", "(Lorg/bukkit/entity/Player;Lcom/typewritermc/basic/entries/dialogue/ActionBarDialogueEntry;)V", "speakerDisplayName", "", "text", "typingDuration", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "Ljava/time/Duration;", "playTime", "value", "", "isCompleted", "()Z", "setCompleted", "(Z)V", "init", "", "tick", "context", "Lcom/typewritermc/engine/paper/entry/dialogue/TickContext;", "end", "dispose", "Companion", "BasicExtension"})
public final class JavaActionBarDialogueDialogueMessenger
extends DialogueMessenger<ActionBarDialogueEntry> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String speakerDisplayName;
    @NotNull
    private String text;
    private Duration typingDuration;
    private Duration playTime;

    public JavaActionBarDialogueDialogueMessenger(@NotNull Player player, @NotNull ActionBarDialogueEntry entry) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        super(player, (DialogueEntry)entry);
        this.speakerDisplayName = "";
        this.text = "";
        this.typingDuration = Duration.ZERO;
        this.playTime = Duration.ZERO;
    }

    public boolean isCompleted() {
        return this.playTime.compareTo(this.typingDuration) >= 0;
    }

    public void setCompleted(boolean value) {
        this.playTime = !value ? Duration.ZERO : this.typingDuration;
    }

    public void init() {
        super.init();
        this.speakerDisplayName = PlaceholderExpansionKt.parsePlaceholders((String)((String)((ActionBarDialogueEntry)this.getEntry()).getSpeakerDisplayName().get(this.getPlayer())), (Player)this.getPlayer());
        this.text = PlaceholderExpansionKt.parsePlaceholders((String)((String)((ActionBarDialogueEntry)this.getEntry()).getText().get(this.getPlayer())), (Player)this.getPlayer());
        this.typingDuration = MessengerFinderKt.getTypingDurationType().totalDuration(MiniMessagesKt.stripped((String)this.text), (Duration)((ActionBarDialogueEntry)this.getEntry()).getDuration().get(this.getPlayer()));
        ConfirmationKey confirmationKey = MessengerFinderKt.getConfirmationKey();
        Listener listener = (Listener)this;
        UUID uUID = this.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        confirmationKey.listen(listener, uUID, () -> JavaActionBarDialogueDialogueMessenger.init$lambda$0(this));
        ChatHistory.resendMessages$default((ChatHistory)ChatHistoryHandlerKt.getChatHistory((Player)this.getPlayer()), (Player)this.getPlayer(), (boolean)false, (int)2, null);
        ActionBarBlockerKt.startBlockingActionBar((Player)this.getPlayer());
    }

    public void tick(@NotNull TickContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.getState() != MessengerState.RUNNING) {
            return;
        }
        this.playTime = this.playTime.plus(context.getDeltaTime());
        String rawText = MiniMessagesKt.stripped((String)this.text);
        TypingDurationType typingDurationType = MessengerFinderKt.getTypingDurationType();
        Duration duration = this.playTime;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"playTime");
        double percentage = typingDurationType.calculatePercentage(duration, (Duration)((ActionBarDialogueEntry)this.getEntry()).getDuration().get(this.getPlayer()), rawText);
        if (percentage > 1.1) {
            Duration duration2 = this.playTime;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"playTime");
            if (ExtensionsKt.toTicks((Duration)duration2) % (long)40 > 0L) {
                return;
            }
        }
        Component component = MiniMessagesKt.splitPercentage((Component)MiniMessagesKt.asMini((String)this.text), (double)percentage).color((TextColor)NamedTextColor.WHITE);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"color(...)");
        Component message = component;
        int paddingSize = MiniMessagesKt.stripped((String)this.text).length() - MiniMessagesKt.plainText((Component)message).length();
        String padding = StringsKt.repeat((CharSequence)" ", (int)paddingSize);
        TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.parsed((String)"speaker", (String)this.speakerDisplayName), Placeholder.component((String)"message", (ComponentLike)((ComponentLike)message)), Placeholder.unparsed((String)"padding", (String)padding)};
        Component component2 = MiniMessagesKt.asMiniWithResolvers((String)JavaActionBarDialogueDialogueMessengerKt.getActionBarFormat(), (TagResolver[])tagResolverArray);
        ActionBarBlockerKt.acceptActionBarMessage((Player)this.getPlayer(), (Component)component2);
        this.getPlayer().sendActionBar(component2);
    }

    public void end() {
    }

    public void dispose() {
        super.dispose();
        ActionBarBlockerKt.stopBlockingActionBar((Player)this.getPlayer());
        this.getPlayer().sendActionBar((Component)Component.empty());
    }

    private static final Unit init$lambda$0(JavaActionBarDialogueDialogueMessenger this$0) {
        this$0.completeOrFinish();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/typewritermc/basic/entries/dialogue/messengers/actionbar/JavaActionBarDialogueDialogueMessenger$Companion;", "Lcom/typewritermc/engine/paper/entry/dialogue/MessengerFilter;", "<init>", "()V", "filter", "", "player", "Lorg/bukkit/entity/Player;", "entry", "Lcom/typewritermc/engine/paper/entry/entries/DialogueEntry;", "BasicExtension"})
    public static final class Companion
    implements MessengerFilter {
        private Companion() {
        }

        public boolean filter(@NotNull Player player, @NotNull DialogueEntry entry) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

