/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.audience;

import com.typewritermc.basic.entries.audience.GameTimeRange;
import com.typewritermc.core.entries.Ref;
import com.typewritermc.engine.paper.TypewriterPaperPluginKt;
import com.typewritermc.engine.paper.entry.entries.AudienceFilter;
import com.typewritermc.engine.paper.entry.entries.AudienceFilterEntry;
import com.typewritermc.engine.paper.entry.entries.TickableDisplay;
import com.typewritermc.engine.paper.entry.entries.Var;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import lirand.api.extensions.server.ServerExtensionsKt;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B3\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0003J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0016R\u0019\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/typewritermc/basic/entries/audience/GameTimeAudienceFilter;", "Lcom/typewritermc/engine/paper/entry/entries/AudienceFilter;", "Lcom/typewritermc/engine/paper/entry/entries/TickableDisplay;", "ref", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/AudienceFilterEntry;", "world", "Lcom/typewritermc/engine/paper/entry/entries/Var;", "Lcom/typewritermc/core/utils/point/World;", "activeTimes", "", "Lcom/typewritermc/basic/entries/audience/GameTimeRange;", "<init>", "(Lcom/typewritermc/core/entries/Ref;Lcom/typewritermc/engine/paper/entry/entries/Var;Ljava/util/List;)V", "getRef", "()Lcom/typewritermc/core/entries/Ref;", "filter", "", "player", "Lorg/bukkit/entity/Player;", "onWorldChange", "", "event", "Lorg/bukkit/event/player/PlayerChangedWorldEvent;", "onPlayerAdd", "tick", "BasicExtension"})
@SourceDebugExtension(value={"SMAP\nGameTimeAudienceEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameTimeAudienceEntry.kt\ncom/typewritermc/basic/entries/audience/GameTimeAudienceFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1755#2,3:88\n1863#2,2:91\n*S KotlinDebug\n*F\n+ 1 GameTimeAudienceEntry.kt\ncom/typewritermc/basic/entries/audience/GameTimeAudienceFilter\n*L\n59#1:88,3\n76#1:91,2\n*E\n"})
public final class GameTimeAudienceFilter
extends AudienceFilter
implements TickableDisplay {
    @NotNull
    private final Ref<? extends AudienceFilterEntry> ref;
    @NotNull
    private final Var<com.typewritermc.core.utils.point.World> world;
    @NotNull
    private final List<GameTimeRange> activeTimes;

    public GameTimeAudienceFilter(@NotNull Ref<? extends AudienceFilterEntry> ref, @NotNull Var<com.typewritermc.core.utils.point.World> world, @NotNull List<GameTimeRange> activeTimes) {
        Intrinsics.checkNotNullParameter(ref, (String)"ref");
        Intrinsics.checkNotNullParameter(world, (String)"world");
        Intrinsics.checkNotNullParameter(activeTimes, (String)"activeTimes");
        super(ref);
        this.ref = ref;
        this.world = world;
        this.activeTimes = activeTimes;
    }

    @NotNull
    public final Ref<? extends AudienceFilterEntry> getRef() {
        return this.ref;
    }

    public boolean filter(@NotNull Player player) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (!Intrinsics.areEqual((Object)player.getWorld().getUID().toString(), (Object)((com.typewritermc.core.utils.point.World)this.world.get(player)).getIdentifier())) {
                return false;
            }
            long worldTime = player.getWorld().getTime() % (long)24000;
            Iterable $this$any$iv = this.activeTimes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GameTimeRange it = (GameTimeRange)element$iv;
                    boolean bl2 = false;
                    if (!it.contains(worldTime)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @EventHandler
    private final void onWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        this.refresh(player);
    }

    public void onPlayerAdd(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onPlayerAdd(player);
        World world = ServerExtensionsKt.getServer().getWorld(((com.typewritermc.core.utils.point.World)this.world.get(player)).getIdentifier());
        if (world == null) {
            TypewriterPaperPluginKt.getLogger().warning("World '" + this.world + "' does not exist, " + this.ref + " will not work.");
        }
    }

    public void tick() {
        Iterable $this$forEach$iv = this.getConsideredPlayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            this.refresh(it);
        }
    }
}

