/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.api.node.types;

import java.util.Optional;
import java.util.regex.Pattern;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.node.NodeBuilder;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.ScopedNode;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface RegexPermissionNode
extends ScopedNode<RegexPermissionNode, Builder> {
    @Override
    default public @NonNull NodeType<RegexPermissionNode> getType() {
        return NodeType.REGEX_PERMISSION;
    }

    public @NonNull String getPatternString();

    public @NonNull Optional<Pattern> getPattern();

    public static @NonNull Builder builder() {
        return LuckPermsProvider.get().getNodeBuilderRegistry().forRegexPermission();
    }

    public static @NonNull Builder builder(@NonNull String pattern) {
        return RegexPermissionNode.builder().pattern(pattern);
    }

    public static @NonNull Builder builder(@NonNull Pattern pattern) {
        return RegexPermissionNode.builder().pattern(pattern);
    }

    public static interface Builder
    extends NodeBuilder<RegexPermissionNode, Builder> {
        public @NonNull Builder pattern(@NonNull String var1);

        public @NonNull Builder pattern(@NonNull Pattern var1);
    }
}

