/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.api.node;

import java.util.Locale;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.ChatMetaNode;
import net.luckperms.api.node.types.PrefixNode;
import net.luckperms.api.node.types.SuffixNode;
import org.checkerframework.checker.nullness.qual.NonNull;

public enum ChatMetaType {
    PREFIX(NodeType.PREFIX){

        @Override
        public @NonNull ChatMetaNode.Builder<?, ?> builder() {
            return PrefixNode.builder();
        }

        @Override
        public @NonNull ChatMetaNode.Builder<?, ?> builder(@NonNull String prefix, int priority) {
            return PrefixNode.builder(prefix, priority);
        }
    }
    ,
    SUFFIX(NodeType.SUFFIX){

        @Override
        public @NonNull ChatMetaNode.Builder<?, ?> builder() {
            return SuffixNode.builder();
        }

        @Override
        public @NonNull ChatMetaNode.Builder<?, ?> builder(@NonNull String suffix, int priority) {
            return SuffixNode.builder(suffix, priority);
        }
    };

    private final String name;
    private final NodeType<? extends ChatMetaNode<?, ?>> nodeType;

    private ChatMetaType(NodeType<? extends ChatMetaNode<?, ?>> nodeType) {
        this.name = nodeType.name().toLowerCase(Locale.ROOT);
        this.nodeType = nodeType;
    }

    public @NonNull NodeType<? extends ChatMetaNode<?, ?>> nodeType() {
        return this.nodeType;
    }

    public abstract @NonNull ChatMetaNode.Builder<?, ?> builder();

    public abstract @NonNull ChatMetaNode.Builder<?, ?> builder(@NonNull String var1, int var2);

    public String toString() {
        return this.name;
    }
}

