/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.bukkit;

import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.util.CachedServerIcon;
import org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.minimotd.lib.io.papermc.lib.PaperLib;
import xyz.jpenilla.minimotd.lib.net.kyori.adventure.text.Component;
import xyz.jpenilla.minimotd.lib.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import xyz.jpenilla.minimotd.lib.platform_bukkit.xyz.jpenilla.minimotd.common.MiniMOTD;
import xyz.jpenilla.minimotd.lib.platform_bukkit.xyz.jpenilla.minimotd.common.PingResponse;
import xyz.jpenilla.minimotd.lib.platform_bukkit.xyz.jpenilla.minimotd.common.config.MiniMOTDConfig;

public final class PingListener
implements Listener {
    private final MiniMOTD<CachedServerIcon> miniMOTD;
    private final LegacyComponentSerializer unusualHexSerializer = LegacyComponentSerializer.builder().hexColors().useUnusualXRepeatedCharacterHexFormat().build();

    PingListener(@NonNull MiniMOTD<CachedServerIcon> miniMOTD) {
        this.miniMOTD = miniMOTD;
    }

    @EventHandler
    public void handlePing(@NonNull ServerListPingEvent event) {
        MiniMOTDConfig cfg = this.miniMOTD.configManager().mainConfig();
        PingResponse<CachedServerIcon> response = this.miniMOTD.createMOTD(cfg, event.getNumPlayers(), event.getMaxPlayers());
        event.setMaxPlayers(response.playerCount().maxPlayers());
        response.motd(motd -> {
            if (PaperLib.getMinecraftVersion() > 15) {
                event.setMotd(this.unusualHexSerializer.serialize((Component)motd));
            } else {
                event.setMotd(LegacyComponentSerializer.legacySection().serialize((Component)motd));
            }
        });
        response.icon(icon -> {
            try {
                event.setServerIcon(icon);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        });
    }
}

