/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.bukkit;

import java.awt.image.BufferedImage;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.CachedServerIcon;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.minimotd.bukkit.BukkitCommand;
import xyz.jpenilla.minimotd.bukkit.PaperPingListener;
import xyz.jpenilla.minimotd.bukkit.PingListener;
import xyz.jpenilla.minimotd.lib.io.papermc.lib.PaperLib;
import xyz.jpenilla.minimotd.lib.net.kyori.adventure.platform.bukkit.BukkitAudiences;
import xyz.jpenilla.minimotd.lib.org.bstats.bukkit.Metrics;
import xyz.jpenilla.minimotd.lib.org.slf4j.Logger;
import xyz.jpenilla.minimotd.lib.org.slf4j.LoggerFactory;
import xyz.jpenilla.minimotd.lib.platform_bukkit.xyz.jpenilla.minimotd.common.MiniMOTD;
import xyz.jpenilla.minimotd.lib.platform_bukkit.xyz.jpenilla.minimotd.common.MiniMOTDPlatform;
import xyz.jpenilla.minimotd.lib.platform_bukkit.xyz.jpenilla.minimotd.common.util.UpdateChecker;

public final class MiniMOTDPlugin
extends JavaPlugin
implements MiniMOTDPlatform<CachedServerIcon> {
    private static final boolean PAPER_PING_EVENT_EXISTS = MiniMOTDPlugin.findClass("com.destroystokyo.paper.event.server.PaperServerListPingEvent") != null;
    private Logger logger;
    private MiniMOTD<CachedServerIcon> miniMOTD;
    private BukkitAudiences audiences;

    public void onEnable() {
        this.logger = LoggerFactory.getLogger(this.getName());
        this.miniMOTD = new MiniMOTD<CachedServerIcon>(this);
        this.audiences = BukkitAudiences.create((Plugin)this);
        if (PAPER_PING_EVENT_EXISTS) {
            this.getServer().getPluginManager().registerEvents((Listener)new PaperPingListener(this.miniMOTD), (Plugin)this);
        } else {
            this.getServer().getPluginManager().registerEvents((Listener)new PingListener(this.miniMOTD), (Plugin)this);
            if (PaperLib.getMinecraftVersion() >= 12) {
                this.suggestPaper();
            }
        }
        PluginCommand command = this.getCommand("minimotd");
        if (command != null) {
            BukkitCommand bukkitCommand = new BukkitCommand(this);
            command.setExecutor((CommandExecutor)bukkitCommand);
            command.setTabCompleter((TabCompleter)bukkitCommand);
        }
        Metrics metrics = new Metrics(this, 8132);
        if (this.miniMOTD.configManager().pluginSettings().updateChecker()) {
            try {
                Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
                CompletableFuture.runAsync(() -> new UpdateChecker().checkVersion().forEach(this.logger::info)).whenComplete(($, thr) -> {
                    if (thr != null) {
                        this.logger.warn("Exception checking for updates", (Throwable)thr);
                    }
                });
            }
            catch (ReflectiveOperationException ex) {
                this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, () -> new UpdateChecker().checkVersion().forEach(this.logger::info));
            }
        }
    }

    public @NonNull MiniMOTD<CachedServerIcon> miniMOTD() {
        return this.miniMOTD;
    }

    @Override
    public @NonNull Path dataDirectory() {
        return this.getDataFolder().toPath();
    }

    @Override
    public @NonNull Logger logger() {
        return this.logger;
    }

    @Override
    public @NonNull CachedServerIcon loadIcon(@NonNull BufferedImage image) throws Exception {
        return this.getServer().loadServerIcon(image);
    }

    public @NonNull BukkitAudiences audiences() {
        return this.audiences;
    }

    private void suggestPaper() {
        this.logger.warn("======================================================");
        this.logger.warn(" MiniMOTD works better if you use Paper as your server");
        this.logger.warn(" software.");
        this.logger.warn(" ");
        this.logger.warn(" Spigot does not include the necessary APIs for all");
        this.logger.warn(" of MiniMOTD's features to operate. MiniMOTD was");
        this.logger.warn(" designed to work with Paper and it's expanded API");
        this.logger.warn(" for full compatibility.");
        this.logger.warn(" ");
        this.logger.warn(" Get Paper from https://papermc.io/downloads");
        this.logger.warn("======================================================");
    }

    private static @Nullable Class<?> findClass(@NonNull String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }
}

