/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.brigadier.permission;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.brigadier.permission.BrigadierPermissionChecker;
import org.incendo.cloud.internal.CommandNode;
import org.incendo.cloud.permission.Permission;

@API(status=API.Status.INTERNAL, since="2.0.0")
public final class BrigadierPermissionPredicate<C, S>
implements Predicate<S> {
    private final SenderMapper<S, C> senderMapper;
    private final BrigadierPermissionChecker<C> permissionChecker;
    private final CommandNode<?> node;

    public BrigadierPermissionPredicate(@NonNull SenderMapper<S, C> senderMapper, @NonNull BrigadierPermissionChecker<C> permissionChecker, @NonNull CommandNode<?> node) {
        this.senderMapper = senderMapper;
        this.permissionChecker = permissionChecker;
        this.node = node;
    }

    @Override
    public boolean test(@NonNull S source) {
        C cloudSender = this.senderMapper.map(source);
        Map accessMap = this.node.nodeMeta().getOrDefault(CommandNode.META_KEY_ACCESS, Collections.emptyMap());
        for (Map.Entry entry : accessMap.entrySet()) {
            if (!GenericTypeReflector.isSuperType((Type)entry.getKey(), cloudSender.getClass()) || !this.permissionChecker.hasPermission(cloudSender, (Permission)entry.getValue())) continue;
            return true;
        }
        return false;
    }
}

