/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.world_properties.server;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.VersionHelper;
import com.moulberry.axiom.world_properties.WorldPropertyDataType;
import com.moulberry.axiom.world_properties.server.PropertyUpdateResult;
import com.moulberry.axiom.world_properties.server.ServerWorldPropertyBase;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class ServerWorldPropertyHolder<T> {
    private T value;
    private ServerWorldPropertyBase<T> property;
    private boolean unsyncedValue = false;

    public ServerWorldPropertyHolder(T value, ServerWorldPropertyBase<T> property) {
        this.value = value;
        this.property = property;
    }

    public MinecraftKey getId() {
        return this.property.getId();
    }

    public WorldPropertyDataType<T> getType() {
        return this.property.widget.dataType();
    }

    public ServerWorldPropertyBase<T> getProperty() {
        return this.property;
    }

    public void update(Player player, World world, byte[] data) {
        Object newValue = this.property.widget.dataType().deserialize(data);
        PropertyUpdateResult result = this.property.handleUpdateProperty(player, world, newValue);
        if (result.isUpdate()) {
            this.value = newValue;
            if (result.isSync()) {
                this.sync(world);
            } else {
                this.unsyncedValue = true;
            }
        }
    }

    public void setValueWithoutSyncing(T value) {
        this.value = value;
    }

    public void setValue(World world, T value) {
        boolean sync = this.unsyncedValue || !Objects.equals(value, this.value);
        this.value = value;
        if (sync) {
            this.sync(world);
        }
    }

    public void sync(World world) {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.a(this.getId());
        buf.d(this.property.widget.dataType().getTypeId());
        buf.a(this.property.widget.dataType().serialize(this.value));
        byte[] message = ByteBufUtil.getBytes((ByteBuf)buf);
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>();
        for (Player player : world.getPlayers()) {
            if (!AxiomPaper.PLUGIN.activeAxiomPlayers.contains(player.getUniqueId())) continue;
            players.add(((CraftPlayer)player).getHandle());
        }
        VersionHelper.sendCustomPayloadToAll(players, "axiom:set_world_property", message);
        this.unsyncedValue = false;
    }

    public void write(PacketDataSerializer friendlyByteBuf) {
        friendlyByteBuf.a(this.getId());
        friendlyByteBuf.a(this.property.name);
        friendlyByteBuf.writeBoolean(this.property.localizeName);
        this.property.widget.write(friendlyByteBuf);
        friendlyByteBuf.a(this.property.widget.dataType().serialize(this.value));
    }
}

