/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.world_properties;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public abstract class WorldPropertyDataType<T> {
    public static WorldPropertyDataType<Boolean> BOOLEAN = new WorldPropertyDataType<Boolean>(){

        @Override
        public int getTypeId() {
            return 0;
        }

        @Override
        public byte[] serialize(Boolean value) {
            return new byte[]{value != null && value != false ? (byte)1 : 0};
        }

        @Override
        public Boolean deserialize(byte[] bytes) {
            return bytes[0] != 0;
        }
    };
    public static WorldPropertyDataType<Integer> INTEGER = new WorldPropertyDataType<Integer>(){

        @Override
        public int getTypeId() {
            return 1;
        }

        @Override
        public byte[] serialize(Integer value) {
            if (value == null) {
                value = 0;
            }
            PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer((int)8));
            buf.d(value.intValue());
            return ByteBufUtil.getBytes((ByteBuf)buf);
        }

        @Override
        public Integer deserialize(byte[] bytes) {
            PacketDataSerializer buf = new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])bytes));
            return buf.m();
        }
    };
    public static WorldPropertyDataType<String> STRING = new WorldPropertyDataType<String>(){

        @Override
        public int getTypeId() {
            return 2;
        }

        @Override
        public byte[] serialize(String value) {
            if (value == null) {
                value = "";
            }
            return value.getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public String deserialize(byte[] bytes) {
            return new String(bytes, StandardCharsets.UTF_8);
        }
    };
    public static WorldPropertyDataType<Item> ITEM = new WorldPropertyDataType<Item>(){

        @Override
        public int getTypeId() {
            return 3;
        }

        @Override
        public byte[] serialize(Item value) {
            if (value == null) {
                value = Items.a;
            }
            PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer((int)8));
            buf.a((Registry)BuiltInRegistries.i, (Object)value);
            return ByteBufUtil.getBytes((ByteBuf)buf);
        }

        @Override
        public Item deserialize(byte[] bytes) {
            PacketDataSerializer buf = new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])bytes));
            return (Item)buf.a((Registry)BuiltInRegistries.i);
        }
    };
    public static WorldPropertyDataType<Block> BLOCK = new WorldPropertyDataType<Block>(){

        @Override
        public int getTypeId() {
            return 4;
        }

        @Override
        public byte[] serialize(Block value) {
            if (value == null) {
                value = Blocks.a;
            }
            PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer((int)8));
            buf.a((Registry)BuiltInRegistries.f, (Object)value);
            return ByteBufUtil.getBytes((ByteBuf)buf);
        }

        @Override
        public Block deserialize(byte[] bytes) {
            PacketDataSerializer buf = new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])bytes));
            return (Block)buf.a((Registry)BuiltInRegistries.f);
        }
    };
    public static WorldPropertyDataType<Void> EMPTY = new WorldPropertyDataType<Void>(){

        @Override
        public int getTypeId() {
            return 5;
        }

        @Override
        public byte[] serialize(Void value) {
            return new byte[0];
        }

        @Override
        public Void deserialize(byte[] bytes) {
            return null;
        }
    };

    public abstract int getTypeId();

    public abstract byte[] serialize(T var1);

    public abstract T deserialize(byte[] var1);
}

