/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.viaversion;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.moulberry.axiom.buffer.BlockBuffer;
import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.data.MappingData;
import com.viaversion.viaversion.api.data.Mappings;
import com.viaversion.viaversion.api.minecraft.chunks.DataPalette;
import com.viaversion.viaversion.api.minecraft.chunks.PaletteType;
import com.viaversion.viaversion.api.protocol.ProtocolPathEntry;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.chunk.PaletteType1_18;
import com.viaversion.viaversion.api.type.types.chunk.PaletteType1_21_5;
import com.viaversion.viaversion.util.MathUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.SharedConstants;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryBlockID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.DataPaletteBlock;

public class ViaVersionHelper {
    private static final Int2ObjectOpenHashMap<RegistryBlockID<IBlockData>> blockRegistryCache = new Int2ObjectOpenHashMap();
    private static final Int2ObjectOpenHashMap<String> blockRegistryErrorCache = new Int2ObjectOpenHashMap();
    private static final int UNNAMED_COMPOUND_TAG_CHANGE_VERSION = 764;
    private static final LoadingCache<Integer, Type<DataPalette>> PALETTE_TYPE_1_21_5 = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Integer, Type<DataPalette>>(){

        public Type<DataPalette> load(Integer size) {
            return new PaletteType1_21_5(PaletteType.BLOCKS, size.intValue());
        }
    });
    private static final LoadingCache<Integer, Type<DataPalette>> PALETTE_TYPE_1_18 = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Integer, Type<DataPalette>>(){

        public Type<DataPalette> load(Integer size) {
            return new PaletteType1_18(PaletteType.BLOCKS, size.intValue());
        }
    });

    public static RegistryBlockID<IBlockData> getBlockRegistryForVersion(RegistryBlockID<IBlockData> mapper, int playerVersion) {
        if (blockRegistryErrorCache.containsKey(playerVersion)) {
            throw new RuntimeException((String)blockRegistryErrorCache.get(playerVersion));
        }
        if (blockRegistryCache.containsKey(playerVersion)) {
            return (RegistryBlockID)blockRegistryCache.get(playerVersion);
        }
        List path = Via.getManager().getProtocolManager().getProtocolPath(playerVersion, SharedConstants.c());
        if (path == null) {
            blockRegistryErrorCache.put(playerVersion, (Object)"Failed to find protocol path");
            throw new RuntimeException("Failed to find protocol path");
        }
        for (int i = path.size() - 1; i >= 0; --i) {
            ProtocolPathEntry protocolPathEntry = (ProtocolPathEntry)path.get(i);
            MappingData mappingData = protocolPathEntry.protocol().getMappingData();
            if (mappingData == null) {
                blockRegistryErrorCache.put(playerVersion, (Object)("Failed to load mapping data (" + protocolPathEntry + ")"));
                throw new RuntimeException("Failed to load mapping data (" + protocolPathEntry + ")");
            }
            Mappings blockStateMappings = mappingData.getBlockStateMappings();
            if (blockStateMappings == null) {
                blockRegistryErrorCache.put(playerVersion, (Object)("Failed to load BlockState mappings (" + protocolPathEntry + ")"));
                throw new RuntimeException("Failed to load BlockState mappings (" + protocolPathEntry + ")");
            }
            mapper = ViaVersionHelper.applyMappings(mapper, blockStateMappings);
        }
        blockRegistryCache.put(playerVersion, mapper);
        return mapper;
    }

    private static RegistryBlockID<IBlockData> applyMappings(RegistryBlockID<IBlockData> registry, Mappings mappings) {
        int i;
        RegistryBlockID newBlockRegistry = new RegistryBlockID();
        int size = mappings.mappedSize();
        for (i = 0; i < size; ++i) {
            newBlockRegistry.a((Object)BlockBuffer.EMPTY_STATE, i);
        }
        for (i = registry.b() - 1; i >= 0; --i) {
            int newId;
            IBlockData blockState = (IBlockData)registry.a(i);
            if (blockState == null || (newId = mappings.getNewId(i)) < 0) continue;
            newBlockRegistry.a((Object)blockState, newId);
        }
        int newEmptyStateId = mappings.getNewId(registry.a((Object)BlockBuffer.EMPTY_STATE));
        if (newEmptyStateId >= 0) {
            newBlockRegistry.a((Object)BlockBuffer.EMPTY_STATE, newEmptyStateId);
        }
        return newBlockRegistry;
    }

    public static NBTTagCompound readTagViaVersion(PacketDataSerializer friendlyByteBuf, int playerVersion) {
        Type<CompoundTag> from = ViaVersionHelper.getTagType(playerVersion);
        Type<CompoundTag> to = ViaVersionHelper.getTagType(SharedConstants.c());
        return ViaVersionHelper.readTagViaVersion(friendlyByteBuf, from, to);
    }

    private static Type<CompoundTag> getTagType(int version) {
        if (version < 764) {
            return Types.NAMED_COMPOUND_TAG;
        }
        return Types.COMPOUND_TAG;
    }

    private static NBTTagCompound readTagViaVersion(PacketDataSerializer friendlyByteBuf, Type<CompoundTag> from, Type<CompoundTag> to) {
        if (from == to) {
            return friendlyByteBuf.p();
        }
        PacketDataSerializer buffer = new PacketDataSerializer(Unpooled.buffer());
        to.write((ByteBuf)buffer, (Object)((CompoundTag)from.read((ByteBuf)friendlyByteBuf)));
        return buffer.p();
    }

    public static void readPalettedContainerViaVersion(PacketDataSerializer friendlyByteBuf, DataPaletteBlock<IBlockData> container, int playerVersion) {
        Type<DataPalette> to;
        Type<DataPalette> from = ViaVersionHelper.getPalettedContainerType(playerVersion, (Registry<IBlockData>)container.c);
        if (from == (to = ViaVersionHelper.getPalettedContainerType(SharedConstants.c(), (Registry<IBlockData>)container.c))) {
            container.a(friendlyByteBuf);
            return;
        }
        PacketDataSerializer buffer = new PacketDataSerializer(Unpooled.buffer());
        to.write((ByteBuf)buffer, (Object)((DataPalette)from.read((ByteBuf)friendlyByteBuf)));
        container.a(buffer);
    }

    private static Type<DataPalette> getPalettedContainerType(int version, Registry<IBlockData> registry) {
        if (version >= 770) {
            return (Type)PALETTE_TYPE_1_21_5.getUnchecked((Object)MathUtil.ceilLog2((int)registry.b()));
        }
        return (Type)PALETTE_TYPE_1_18.getUnchecked((Object)MathUtil.ceilLog2((int)registry.b()));
    }
}

