/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.restrictions;

import com.moulberry.axiom.VersionHelper;
import com.moulberry.axiom.integration.plotsquared.PlotSquaredIntegration;
import com.moulberry.axiom.restrictions.AxiomPermission;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import org.bukkit.entity.Player;

public class Restrictions {
    private static final Map<String, AxiomPermission> PERMISSION_BY_NAME = new LinkedHashMap<String, AxiomPermission>();
    public EnumSet<AxiomPermission> allowedPermissions = EnumSet.of(AxiomPermission.DEFAULT);
    public EnumSet<AxiomPermission> deniedPermissions = EnumSet.noneOf(AxiomPermission.class);
    public int infiniteReachLimit = -1;
    public Set<PlotSquaredIntegration.PlotBox> bounds = Set.of();

    public void send(Player player) {
        PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(Unpooled.buffer());
        friendlyByteBuf.d(this.allowedPermissions.size());
        for (AxiomPermission allowedPermission : this.allowedPermissions) {
            friendlyByteBuf.a(allowedPermission.getInternalName());
        }
        friendlyByteBuf.d(this.deniedPermissions.size());
        for (AxiomPermission disallowedPermission : this.deniedPermissions) {
            friendlyByteBuf.a(disallowedPermission.getInternalName());
        }
        friendlyByteBuf.writeInt(this.infiniteReachLimit);
        friendlyByteBuf.d(this.bounds.size());
        for (PlotSquaredIntegration.PlotBox bound : this.bounds) {
            int minX = bound.min().u();
            int minY = bound.min().v();
            int minZ = bound.min().w();
            int maxX = bound.max().u();
            int maxY = bound.max().v();
            int maxZ = bound.max().w();
            if (minX < -33554431) {
                minX = -33554431;
            }
            if (minX > 0x1FFFFFF) {
                minX = 0x1FFFFFF;
            }
            if (minY < -2047) {
                minY = -2047;
            }
            if (minY > 2047) {
                minY = 2047;
            }
            if (minZ < -33554431) {
                minZ = -33554431;
            }
            if (minZ > 0x1FFFFFF) {
                minZ = 0x1FFFFFF;
            }
            if (maxX < -33554431) {
                maxX = -33554431;
            }
            if (maxX > 0x1FFFFFF) {
                maxX = 0x1FFFFFF;
            }
            if (maxY < -2047) {
                maxY = -2047;
            }
            if (maxY > 2047) {
                maxY = 2047;
            }
            if (maxZ < -33554431) {
                maxZ = -33554431;
            }
            if (maxZ > 0x1FFFFFF) {
                maxZ = 0x1FFFFFF;
            }
            friendlyByteBuf.a(new BlockPosition(minX, minY, minZ));
            friendlyByteBuf.a(new BlockPosition(maxX, maxY, maxZ));
        }
        byte[] bytes = ByteBufUtil.getBytes((ByteBuf)friendlyByteBuf);
        VersionHelper.sendCustomPayload(player, "axiom:restrictions", bytes);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Restrictions that = (Restrictions)o;
        return this.infiniteReachLimit == that.infiniteReachLimit && this.allowedPermissions.equals(that.allowedPermissions) && this.deniedPermissions.equals(that.deniedPermissions) && this.bounds.equals(that.bounds);
    }

    public int hashCode() {
        int result = this.allowedPermissions.hashCode();
        result = 31 * result + this.deniedPermissions.hashCode();
        result = 31 * result + this.infiniteReachLimit;
        result = 31 * result + this.bounds.hashCode();
        return result;
    }

    public String toString() {
        return "Restrictions{allowedPermissions=" + this.allowedPermissions + ", deniedPermissions=" + this.deniedPermissions + ", infiniteReachLimit=" + this.infiniteReachLimit + ", bounds=" + this.bounds + "}";
    }

    static {
        for (AxiomPermission value : AxiomPermission.values()) {
            PERMISSION_BY_NAME.put(value.getInternalName(), value);
        }
    }
}

